/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.coarse;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanMutatorFactory;
import org.wildfly.clustering.infinispan.listener.PostActivateListener;
import org.wildfly.clustering.infinispan.listener.PrePassivateListener;
import org.wildfly.clustering.infinispan.notifications.PredicateKeyFilter;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSession;
import org.wildfly.clustering.web.cache.session.ImmutableSessionActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributeActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.coarse.CoarseImmutableSessionAttributes;
import org.wildfly.clustering.web.cache.session.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKeyFilter;
import org.wildfly.clustering.web.infinispan.session.coarse.SessionAttributesKey;
import org.wildfly.clustering.web.infinispan.session.coarse.SessionAttributesKeyFilter;
import org.wildfly.clustering.web.session.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class CoarseSessionAttributesFactory<S, C, L, V>
implements SessionAttributesFactory<C, Map<String, Object>> {
    private final Cache<SessionAttributesKey, V> cache;
    private final Cache<SessionAttributesKey, V> writeCache;
    private final Cache<SessionAttributesKey, V> silentCache;
    private final Marshaller<Map<String, Object>, V> marshaller;
    private final CacheProperties properties;
    private final Immutability immutability;
    private final MutatorFactory<SessionAttributesKey, V> mutatorFactory;
    private final HttpSessionActivationListenerProvider<S, C, L> provider;
    private final Function<String, SessionAttributeActivationNotifier> notifierFactory;
    private final Object evictListener;
    private final Object prePassivateListener;
    private final Object postActivateListener;

    public CoarseSessionAttributesFactory(InfinispanSessionAttributesFactoryConfiguration<S, C, L, Map<String, Object>, V> configuration) {
        this.cache = configuration.getCache();
        this.writeCache = configuration.getWriteOnlyCache();
        this.silentCache = configuration.getSilentWriteCache();
        this.marshaller = configuration.getMarshaller();
        this.immutability = configuration.getImmutability();
        this.properties = configuration.getCacheProperties();
        this.mutatorFactory = new InfinispanMutatorFactory(this.cache, this.properties);
        this.provider = configuration.getHttpSessionActivationListenerProvider();
        this.notifierFactory = configuration.getActivationNotifierFactory();
        this.prePassivateListener = !this.properties.isPersistent() ? new PrePassivateListener(this::prePassivate, configuration.getExecutor()) : null;
        Object object = this.postActivateListener = !this.properties.isPersistent() ? new PostActivateListener(this::postActivate, configuration.getExecutor()) : null;
        if (this.prePassivateListener != null) {
            this.cache.addListener(this.prePassivateListener, (CacheEventFilter)new PredicateKeyFilter((Predicate)((Object)SessionAttributesKeyFilter.INSTANCE)), null);
        }
        if (this.postActivateListener != null) {
            this.cache.addListener(this.postActivateListener, (CacheEventFilter)new PredicateKeyFilter((Predicate)((Object)SessionAttributesKeyFilter.INSTANCE)), null);
        }
        this.evictListener = new PrePassivateListener(this::cascadeEvict, configuration.getExecutor());
        this.cache.addListener(this.evictListener, (CacheEventFilter)new PredicateKeyFilter((Predicate)((Object)SessionCreationMetaDataKeyFilter.INSTANCE)), null);
    }

    public void close() {
        this.cache.removeListener(this.evictListener);
        if (this.prePassivateListener != null) {
            this.cache.removeListener(this.prePassivateListener);
        }
        if (this.postActivateListener != null) {
            this.cache.removeListener(this.postActivateListener);
        }
    }

    public Map<String, Object> createValue(String id, Void context) {
        ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
        try {
            Object value = this.marshaller.write(attributes);
            this.writeCache.put((Object)new SessionAttributesKey(id), value);
            return attributes;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Map<String, Object> findValue(String id) {
        return this.getValue(id, true);
    }

    public Map<String, Object> tryValue(String id) {
        return this.getValue(id, false);
    }

    private Map<String, Object> getValue(String id, boolean purgeIfInvalid) {
        block3: {
            Object value = this.cache.get((Object)new SessionAttributesKey(id));
            if (value != null) {
                try {
                    return (Map)this.marshaller.read(value);
                }
                catch (IOException e) {
                    InfinispanWebLogger.ROOT_LOGGER.failedToActivateSession(e, id);
                    if (!purgeIfInvalid) break block3;
                    this.purge(id);
                }
            }
        }
        return null;
    }

    public boolean remove(String id) {
        return this.delete(this.writeCache, id);
    }

    public boolean purge(String id) {
        return this.delete(this.silentCache, id);
    }

    private boolean delete(Cache<SessionAttributesKey, V> cache, String id) {
        cache.remove((Object)new SessionAttributesKey(id));
        return true;
    }

    public SessionAttributes createSessionAttributes(String id, Map<String, Object> attributes, ImmutableSessionMetaData metaData, C context) {
        try {
            Mutator mutator = this.properties.isTransactional() && metaData.isNew() ? Mutator.PASSIVE : this.mutatorFactory.createMutator((Object)new SessionAttributesKey(id), this.marshaller.write(attributes));
            ImmutableSessionActivationNotifier notifier = this.properties.isPersistent() ? new ImmutableSessionActivationNotifier(this.provider, (ImmutableSession)new CompositeImmutableSession(id, metaData, this.createImmutableSessionAttributes(id, attributes)), context) : null;
            return new CoarseSessionAttributes(attributes, mutator, this.marshaller, this.immutability, this.properties, (SessionActivationNotifier)notifier);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, Map<String, Object> values) {
        return new CoarseImmutableSessionAttributes(values);
    }

    private void cascadeEvict(SessionCreationMetaDataKey key, Object value) {
        this.cache.evict((Object)new SessionAttributesKey((String)key.getId()));
    }

    private void prePassivate(SessionAttributesKey key, V value) {
        this.notify(key, value, SessionAttributeActivationNotifier.PRE_PASSIVATE);
    }

    private void postActivate(SessionAttributesKey key, V value) {
        this.notify(key, value, SessionAttributeActivationNotifier.POST_ACTIVATE);
    }

    private void notify(SessionAttributesKey key, V value, BiConsumer<SessionAttributeActivationNotifier, Object> notification) {
        String sessionId = (String)key.getId();
        try (SessionAttributeActivationNotifier notifier = this.notifierFactory.apply(sessionId);){
            Map attributes = (Map)this.marshaller.read(value);
            for (Object attributeValue : attributes.values()) {
                notification.accept(notifier, attributeValue);
            }
        }
        catch (IOException e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToActivateSession(e, sessionId);
        }
    }
}

