/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime;

import jakarta.batch.operations.BatchRuntimeException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.ServiceLoader;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;
import org.jberet.spi.SerializableDataProvider;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SerializableData
implements Serializable {
    private static final PrivilegedAction<SerializableDataProvider> loaderAction = new PrivilegedAction<SerializableDataProvider>(){

        @Override
        public SerializableDataProvider run() {
            ServiceLoader<SerializableDataProvider> serviceLoader = ServiceLoader.load(SerializableDataProvider.class);
            if (serviceLoader.iterator().hasNext()) {
                return serviceLoader.iterator().next();
            }
            return new SerializableDataProvider.DefaultSerializableDataProvider();
        }
    };
    private static final SerializableDataProvider provider = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(loaderAction) : loaderAction.run();
    private final byte[] serialized;
    private final Serializable raw;
    private final Class<?> klass;

    private SerializableData(byte[] serialized, Serializable raw, Class<?> klass) {
        this.serialized = serialized;
        this.raw = raw;
        this.klass = klass;
    }

    public static SerializableData of(Serializable data) {
        if (data instanceof SerializableData) {
            return (SerializableData)data;
        }
        if (data instanceof byte[]) {
            return new SerializableData((byte[])data, null, byte[].class);
        }
        if (data == null) {
            return new SerializableData(null, null, null);
        }
        Class<?> c = data.getClass();
        if (c.isArray()) {
            c = c.getComponentType();
        }
        if (SerializableData.requiresSerialization(c)) {
            try {
                return new SerializableData(provider.objectToBytes(data), null, c);
            }
            catch (IOException e) {
                if (data instanceof Throwable) {
                    Throwable exceptionData = (Throwable)data;
                    BatchLogger.LOGGER.failedToSerializeException(e, exceptionData);
                    BatchRuntimeException replacementException = new BatchRuntimeException(exceptionData.getMessage());
                    replacementException.setStackTrace(exceptionData.getStackTrace());
                    try {
                        return new SerializableData(provider.objectToBytes(replacementException), null, c);
                    }
                    catch (IOException e1) {
                        throw BatchMessages.MESSAGES.failedToSerialize(e1, (Serializable)replacementException);
                    }
                }
                throw BatchMessages.MESSAGES.failedToSerialize(e, data);
            }
        }
        return new SerializableData(null, data, c);
    }

    public Serializable deserialize() throws BatchRuntimeException {
        if (this.raw != null) {
            return this.raw;
        }
        if (this.serialized != null) {
            ClassLoader cl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            if (cl == null) {
                cl = WildFlySecurityManager.getClassLoaderPrivileged(SerializableData.class);
            }
            try {
                return provider.bytesToObject(this.serialized, this.klass, cl);
            }
            catch (IOException | ClassNotFoundException e) {
                throw BatchMessages.MESSAGES.failedToDeserialize(e, (Serializable)((Object)Arrays.toString(this.serialized)));
            }
        }
        return null;
    }

    byte[] getSerialized() throws BatchRuntimeException {
        if (this.serialized != null) {
            return this.serialized;
        }
        try {
            return provider.objectToBytes(this.raw);
        }
        catch (IOException e) {
            throw BatchMessages.MESSAGES.failedToSerialize(e, this.raw);
        }
    }

    public int hashCode() {
        int hash = 17;
        if (this.raw != null) {
            hash = 31 * hash + this.raw.hashCode();
        }
        if (this.serialized != null) {
            hash = 31 * hash + Arrays.hashCode(this.serialized);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SerializableData)) {
            return false;
        }
        SerializableData other = (SerializableData)obj;
        return (this.raw == null ? other.raw == null : this.raw.equals(other.raw)) && Arrays.equals(this.serialized, other.serialized);
    }

    private static boolean requiresSerialization(Class<?> c) {
        return !c.isPrimitive() && c != String.class && c != Byte.class && c != Double.class && c != Float.class && c != Integer.class && c != Long.class && c != Short.class && c != BigDecimal.class && c != BigInteger.class;
    }
}

