/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.util.Arrays;
import org.hibernate.SharedSessionContract;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public class ComponentArrayMutabilityPlan
implements MutabilityPlan<Object[]> {
    private final JavaType<Object>[] components;

    public ComponentArrayMutabilityPlan(JavaType<Object>[] components) {
        this.components = components;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Serializable disassemble(Object[] value, SharedSessionContract session) {
        return this.deepCopy(value);
    }

    @Override
    public Object[] assemble(Serializable cached, SharedSessionContract session) {
        return this.deepCopy((Object[])cached);
    }

    @Override
    public final Object[] deepCopy(Object[] value) {
        if (value == null) {
            return null;
        }
        if (value.length != this.components.length) {
            throw new IllegalArgumentException("Value does not have the expected size " + this.components.length + ": " + Arrays.toString(value));
        }
        Object[] copy = new Object[value.length];
        for (int i = 0; i < this.components.length; ++i) {
            copy[i] = this.components[i].getMutabilityPlan().deepCopy(value[i]);
        }
        return copy;
    }
}

