/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.faces;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.MethodExpressionValueChangeListener;
import jakarta.faces.event.ValueChangeEvent;
import jakarta.faces.event.ValueChangeListener;
import jakarta.faces.validator.MethodExpressionValidator;
import jakarta.faces.validator.Validator;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRule;
import jakarta.faces.view.facelets.Metadata;
import jakarta.faces.view.facelets.MetadataTarget;
import jakarta.faces.view.facelets.TagAttribute;

public final class EditableValueHolderRule
extends MetaRule {
    private static final Class[] VALIDATOR_SIG = new Class[]{FacesContext.class, UIComponent.class, Object.class};
    private static final Class[] VALUECHANGE_SIG = new Class[]{ValueChangeEvent.class};
    public static final EditableValueHolderRule Instance = new EditableValueHolderRule();

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (meta.isTargetInstanceOf(EditableValueHolder.class)) {
            if ("validator".equals(name)) {
                if (attribute.isLiteral()) {
                    return new LiteralValidatorMetadata(attribute.getValue());
                }
                return new ValidatorExpressionMetadata(attribute);
            }
            if ("valueChangeListener".equals(name)) {
                return new ValueChangedExpressionMetadata(attribute);
            }
        }
        return null;
    }

    static final class ValidatorExpressionMetadata
    extends Metadata {
        private final TagAttribute attr;

        public ValidatorExpressionMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((EditableValueHolder)instance).addValidator((Validator)new MethodExpressionValidator(this.attr.getMethodExpression(ctx, null, VALIDATOR_SIG)));
        }
    }

    static final class ValueChangedExpressionMetadata
    extends Metadata {
        private final TagAttribute attr;

        public ValueChangedExpressionMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((EditableValueHolder)instance).addValueChangeListener((ValueChangeListener)new MethodExpressionValueChangeListener(this.attr.getMethodExpression(ctx, null, VALUECHANGE_SIG)));
        }
    }

    static final class LiteralValidatorMetadata
    extends Metadata {
        private final String validatorId;

        public LiteralValidatorMetadata(String validatorId) {
            this.validatorId = validatorId;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((EditableValueHolder)instance).addValidator(ctx.getFacesContext().getApplication().createValidator(this.validatorId));
        }
    }
}

