/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.junit.Before;
import org.junit.Test;

public class FailoverListenerTest
extends FailoverTestBase {
    private ServerLocatorInternal locator;
    private ClientSessionFactoryInternal sf;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.getServerLocator();
    }

    @Test
    public void testFailoverListenerCall() throws Exception {
        this.createSessionFactory(2);
        CountDownLatch failureLatch = new CountDownLatch(1);
        CountDownLatch failureDoneLatch = new CountDownLatch(1);
        SessionFactoryFailoverListener listener = new SessionFactoryFailoverListener(failureLatch, failureDoneLatch);
        this.sf.addFailoverListener((FailoverEventListener)listener);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        this.liveServer.crash(new ClientSession[0]);
        FailoverListenerTest.assertTrue((boolean)failureLatch.await(5L, TimeUnit.SECONDS));
        FailoverListenerTest.assertEquals((Object)FailoverEventType.FAILURE_DETECTED, (Object)listener.getFailoverEventType().get(0));
        this.instanceLog.debug((Object)("backup (nowLive) topology = " + this.backupServer.getServer().getClusterManager().getDefaultConnection(null).getTopology().describe()));
        this.instanceLog.debug((Object)"Server Crash!!!");
        FailoverListenerTest.assertTrue((boolean)failureDoneLatch.await(5L, TimeUnit.SECONDS));
        FailoverListenerTest.assertEquals((Object)FailoverEventType.FAILOVER_COMPLETED, (Object)listener.getFailoverEventType().get(1));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
        this.verifyMessageOnServer(1, 1);
        this.instanceLog.debug((Object)"******* starting live server back");
        this.liveServer.start();
        Thread.sleep(1000L);
        FailoverListenerTest.assertEquals((Object)FailoverEventType.FAILURE_DETECTED, (Object)listener.getFailoverEventType().get(2));
        FailoverListenerTest.assertEquals((Object)FailoverEventType.FAILOVER_COMPLETED, (Object)listener.getFailoverEventType().get(3));
        this.instanceLog.debug((Object)("After failback: " + this.locator.getTopology().describe()));
        message = session.createMessage(true);
        this.setBody(1, message);
        producer.send((Message)message);
        session.close();
        this.verifyMessageOnServer(0, 1);
        this.wrapUpSessionFactory();
        FailoverListenerTest.assertEquals((String)"Expected 4 FailoverEvents to be triggered", (long)4L, (long)listener.getFailoverEventType().size());
    }

    private void verifyMessageOnServer(int server, int numberOfMessages) throws Exception {
        ServerLocator backupLocator = this.createInVMLocator(server);
        ClientSessionFactory factorybkp = this.addSessionFactory(this.createSessionFactory(backupLocator));
        ClientSession sessionbkp = factorybkp.createSession(false, false);
        sessionbkp.start();
        ClientConsumer consumerbkp = sessionbkp.createConsumer(ADDRESS);
        for (int i = 0; i < numberOfMessages; ++i) {
            ClientMessage msg = consumerbkp.receive(1000L);
            FailoverListenerTest.assertNotNull((Object)msg);
            msg.acknowledge();
            sessionbkp.commit();
        }
        sessionbkp.close();
        factorybkp.close();
        backupLocator.close();
    }

    @Test
    public void testFailoverFailed() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(1);
        this.sf = this.createSessionFactoryAndWaitForTopology((ServerLocator)this.locator, 2);
        this.backupServer.stop();
        CountDownLatch failureLatch = new CountDownLatch(1);
        CountDownLatch failureDoneLatch = new CountDownLatch(1);
        SessionFactoryFailoverListener listener = new SessionFactoryFailoverListener(failureLatch, failureDoneLatch);
        this.sf.addFailoverListener((FailoverEventListener)listener);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        this.liveServer.crash(session);
        FailoverListenerTest.assertTrue((boolean)failureLatch.await(5L, TimeUnit.SECONDS));
        FailoverListenerTest.assertEquals((Object)FailoverEventType.FAILURE_DETECTED, (Object)listener.getFailoverEventType().get(0));
        FailoverListenerTest.assertTrue((boolean)failureDoneLatch.await(5L, TimeUnit.SECONDS));
        FailoverListenerTest.assertEquals((Object)FailoverEventType.FAILOVER_FAILED, (Object)listener.getFailoverEventType().get(1));
        FailoverListenerTest.assertEquals((String)"Expected 2 FailoverEvents to be triggered", (long)2L, (long)listener.getFailoverEventType().size());
        session.close();
        this.wrapUpSessionFactory();
    }

    private void createSessionFactory(int members) throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(15);
        this.sf = this.createSessionFactoryAndWaitForTopology((ServerLocator)this.locator, members);
    }

    private void wrapUpSessionFactory() {
        this.sf.close();
        FailoverListenerTest.assertEquals((String)"Expecting 0 sessions", (long)0L, (long)this.sf.numSessions());
        FailoverListenerTest.assertEquals((String)"Expecting 0 connections", (long)0L, (long)this.sf.numConnections());
    }

    @Override
    protected void createConfigs() throws Exception {
        this.nodeManager = new InVMNodeManager(false);
        TransportConfiguration liveConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration()).addConnectorConfiguration(liveConnector.getName(), liveConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(FailoverListenerTest.basicClusterConnectionConfig((String)backupConnector.getName(), (String[])new String[]{liveConnector.getName()}));
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.liveConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration()).addClusterConfiguration(FailoverListenerTest.basicClusterConnectionConfig((String)liveConnector.getName(), (String[])new String[]{backupConnector.getName()})).addConnectorConfiguration(liveConnector.getName(), liveConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector);
        this.liveServer = this.createTestableServer(this.liveConfig);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    private ClientSession sendAndConsume(ClientSessionFactory sf, boolean createQueue) throws Exception {
        ClientSession session = sf.createSession(false, true, true);
        if (createQueue) {
            session.createQueue(new QueueConfiguration(ADDRESS));
        }
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(new SimpleString("count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message2 = consumer.receive();
            FailoverListenerTest.assertEquals((Object)"aardvarks", (Object)message2.getBodyBuffer().readString());
            FailoverListenerTest.assertEquals((Object)i, (Object)message2.getObjectProperty(new SimpleString("count")));
            message2.acknowledge();
        }
        ClientMessage message3 = consumer.receiveImmediate();
        consumer.close();
        FailoverListenerTest.assertNull((Object)message3);
        return session;
    }

    public class SessionFactoryFailoverListener
    implements FailoverEventListener {
        private final ArrayList<FailoverEventType> failoverTypeEvent = new ArrayList();
        private final CountDownLatch failureLatch;
        private final CountDownLatch failureDoneLatch;

        public SessionFactoryFailoverListener(CountDownLatch failureLatch, CountDownLatch failureDoneLatch) {
            this.failureLatch = failureLatch;
            this.failureDoneLatch = failureDoneLatch;
        }

        public ArrayList<FailoverEventType> getFailoverEventType() {
            return this.failoverTypeEvent;
        }

        public void failoverEvent(FailoverEventType eventType) {
            this.failoverTypeEvent.add(eventType);
            FailoverListenerTest.this.instanceLog.debug((Object)("Failover event just happen : " + eventType.toString()));
            if (eventType == FailoverEventType.FAILURE_DETECTED) {
                this.failureLatch.countDown();
            } else if (eventType == FailoverEventType.FAILOVER_COMPLETED || eventType == FailoverEventType.FAILOVER_FAILED) {
                this.failureDoneLatch.countDown();
            }
        }
    }
}

