/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.server;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.HashSet;
import java.util.Set;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JMSServerStartStopTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private Connection conn;
    private ActiveMQConnectionFactory jbcf;
    private final Set<ActiveMQConnectionFactory> connectionFactories = new HashSet<ActiveMQConnectionFactory>();

    @Before
    public void setUp() throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager("server-start-stop-config1.xml");
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        ActiveMQJAASSecurityManager sm = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), new SecurityConfiguration());
        this.server = this.addServer((ActiveMQServer)new ActiveMQServerImpl((Configuration)fc, (ActiveMQSecurityManager)sm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStopStart1() throws Exception {
        int numMessages = 5;
        for (int j = 0; j < 5; ++j) {
            this.instanceLog.debug((Object)("Iteration " + j));
            this.server.start();
            ActiveMQConnectionFactory jbcf = this.createConnectionFactory();
            jbcf.setBlockOnDurableSend(true);
            jbcf.setBlockOnNonDurableSend(true);
            Connection conn = jbcf.createConnection();
            try {
                Session sess = conn.createSession(false, 1);
                Queue queue = sess.createQueue("myJMSQueue");
                MessageProducer producer = sess.createProducer((Destination)queue);
                TextMessage tm = sess.createTextMessage("message" + j);
                producer.send((Message)tm);
                continue;
            }
            finally {
                conn.close();
                jbcf.close();
                this.server.stop();
            }
        }
        this.server.start();
        this.jbcf = this.createConnectionFactory();
        this.jbcf.setBlockOnDurableSend(true);
        this.jbcf.setBlockOnNonDurableSend(true);
        this.conn = this.jbcf.createConnection();
        Session sess = this.conn.createSession(false, 1);
        Queue queue = sess.createQueue("myJMSQueue");
        MessageConsumer consumer = sess.createConsumer((Destination)queue);
        this.conn.start();
        for (int i = 0; i < 5; ++i) {
            TextMessage tm = (TextMessage)consumer.receive(10000L);
            Assert.assertNotNull((String)"not null", (Object)tm);
            Assert.assertEquals((Object)("message" + i), (Object)tm.getText());
        }
        this.conn.close();
        this.jbcf.close();
    }

    @Test
    public void testCloseConnectionAfterServerIsShutdown() throws Exception {
        this.server.start();
        this.jbcf = this.createConnectionFactory();
        this.jbcf.setBlockOnDurableSend(true);
        this.jbcf.setBlockOnNonDurableSend(true);
        this.jbcf.setReconnectAttempts(-1);
        this.conn = this.jbcf.createConnection();
        this.server.stop();
        this.conn.close();
    }

    private ActiveMQConnectionFactory createConnectionFactory() {
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(NETTY_CONNECTOR_FACTORY)});
        this.connectionFactories.add(cf);
        return cf;
    }
}

