/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt.imported;

import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.Message;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.junit.Test;

public class MQTTSecurityCRLTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void crlRevokedTest() throws Exception {
        ActiveMQServer server1 = this.initServer();
        BlockingConnection connection1 = null;
        try {
            server1.start();
            while (!server1.isStarted()) {
                Thread.sleep(50L);
            }
            connection1 = this.retrieveMQTTConnection("ssl://localhost:1883", "server-ca-truststore.jks", "securepass", "other-client-keystore.jks", "securepass");
            Topic[] topics = new Topic[]{new Topic("test/+/some/#", QoS.AT_MOST_ONCE)};
            connection1.subscribe(topics);
            String payload1 = "This is message 1";
            connection1.publish("test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            Message message1 = connection1.receive(5L, TimeUnit.SECONDS);
            MQTTSecurityCRLTest.assertEquals((Object)payload1, (Object)new String(message1.getPayload()));
            MQTTSecurityCRLTest.fail((String)"We expect an exception of some sort!");
        }
        catch (SSLException sSLException) {
        }
        catch (EOFException eOFException) {
        }
        finally {
            if (connection1 != null) {
                connection1.disconnect();
            }
            if (server1.isStarted()) {
                server1.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void crlNotRevokedTest() throws Exception {
        ActiveMQServer server1 = this.initServer();
        BlockingConnection connection1 = null;
        try {
            server1.start();
            while (!server1.isStarted()) {
                Thread.sleep(50L);
            }
            connection1 = this.retrieveMQTTConnection("ssl://localhost:1883", "server-ca-truststore.jks", "securepass", "client-keystore.jks", "securepass");
            Topic[] topics = new Topic[]{new Topic("test/+/some/#", QoS.AT_MOST_ONCE)};
            connection1.subscribe(topics);
            String payload1 = "This is message 1";
            connection1.publish("test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            Message message1 = connection1.receive(5L, TimeUnit.SECONDS);
            MQTTSecurityCRLTest.assertEquals((Object)payload1, (Object)new String(message1.getPayload()));
        }
        finally {
            if (connection1 != null) {
                connection1.disconnect();
            }
            if (server1.isStarted()) {
                server1.stop();
            }
        }
    }

    private ActiveMQServer initServer() throws Exception {
        Configuration configuration = this.createDefaultNettyConfig().setSecurityEnabled(false);
        this.addMqttTransportConfiguration(configuration);
        this.addWildCardConfiguration(configuration);
        ActiveMQServer server = this.createServer(true, configuration);
        return server;
    }

    private void addWildCardConfiguration(Configuration configuration) {
        WildcardConfiguration wildcardConfiguration = new WildcardConfiguration();
        wildcardConfiguration.setAnyWords('#');
        wildcardConfiguration.setDelimiter('/');
        wildcardConfiguration.setRoutingEnabled(true);
        wildcardConfiguration.setSingleWord('+');
        configuration.setWildCardConfiguration(wildcardConfiguration);
    }

    private void addMqttTransportConfiguration(Configuration configuration) throws IOException {
        TransportConfiguration transportConfiguration = new TransportConfiguration(NettyAcceptorFactory.class.getCanonicalName(), null, "mqtt", null);
        transportConfiguration.getParams().put("sslEnabled", true);
        transportConfiguration.getParams().put("trustStorePath", "client-ca-truststore.jks");
        transportConfiguration.getParams().put("trustStorePassword", "securepass");
        transportConfiguration.getParams().put("keyStorePath", "server-keystore.jks");
        transportConfiguration.getParams().put("keyStorePassword", "securepass");
        transportConfiguration.getParams().put("crlPath", "other-client-crl.pem");
        transportConfiguration.getParams().put("needClientAuth", "true");
        transportConfiguration.getParams().put("port", "1883");
        transportConfiguration.getParams().put("host", "localhost");
        transportConfiguration.getParams().put("protocols", "MQTT");
        configuration.getAcceptorConfigurations().add(transportConfiguration);
    }

    private BlockingConnection retrieveMQTTConnection(String host, String truststorePath, String truststorePass, String keystorePath, String keystorePass) throws Exception {
        MQTT mqtt = new MQTT();
        mqtt.setConnectAttemptsMax(1L);
        mqtt.setReconnectAttemptsMax(0L);
        mqtt.setHost(host);
        SSLContext sslContext = new SSLSupport().setKeystorePath(keystorePath).setKeystorePassword(keystorePass).setTruststorePath(truststorePath).setTruststorePassword(truststorePass).createContext();
        mqtt.setSslContext(sslContext);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        return connection;
    }
}

