/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.rest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.webapp.WebAppContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import shaded.org.apache.commons.io.FileUtils;

public class RestTestBase
extends JMSTestBase {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();
    protected Server server;
    protected File webAppDir;
    protected HandlerList handlers;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.webAppDir = this.testFolder.newFolder("test-apps");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        super.tearDown();
    }

    public Server createJettyServer(String host, int port) throws Exception {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost(host);
        connector.setPort(port);
        this.server.setConnectors(new Connector[]{connector});
        this.handlers = new HandlerList();
        this.server.setHandler((Handler)this.handlers);
        return this.server;
    }

    public WebAppContext deployWebApp(String contextPath, File warFile) {
        WebAppContext webapp = new WebAppContext();
        if (contextPath.startsWith("/")) {
            webapp.setContextPath(contextPath);
        } else {
            webapp.setContextPath("/" + contextPath);
        }
        webapp.setWar(warFile.getAbsolutePath());
        this.handlers.addHandler((Handler)webapp);
        return webapp;
    }

    public File getResourceFile(String resPath, String warName) throws IOException {
        InputStream input = RestTestBase.class.getResourceAsStream(resPath);
        File result = new File(this.webAppDir, warName);
        FileUtils.copyInputStreamToFile((InputStream)input, (File)result);
        return result;
    }
}

