/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Timer;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.ejb3.deployment.processors.AroundTimeoutAnnotationParsingProcessor;
import org.jboss.as.ejb3.deployment.processors.TimerServiceDeploymentProcessor;
import org.jboss.as.ejb3.deployment.processors.annotation.TimerServiceAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.TimerMethodMergingProcessor;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.TimerServiceResourceDefinition;
import org.jboss.as.ejb3.timerservice.TimerServiceMetaData;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class TimerServiceAdd
extends AbstractBoottimeAddStepHandler {
    public static final TimerServiceAdd INSTANCE = new TimerServiceAdd();

    private TimerServiceAdd() {
        super(TimerServiceResourceDefinition.ATTRIBUTES);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        final String threadPoolName = TimerServiceResourceDefinition.THREAD_POOL_NAME.resolveModelAttribute(context, model).asStringOrNull();
        final TimerServiceMetaData defaultMetaData = new TimerServiceMetaData();
        defaultMetaData.setDataStoreName(TimerServiceResourceDefinition.DEFAULT_DATA_STORE.resolveModelAttribute(context, model).asStringOrNull());
        defaultMetaData.setPersistentTimerManagementProvider(TimerServiceResourceDefinition.DEFAULT_PERSISTENT_TIMER_MANAGEMENT.resolveModelAttribute(context, model).asStringOrNull());
        defaultMetaData.setTransientTimerManagementProvider(TimerServiceResourceDefinition.DEFAULT_TRANSIENT_TIMER_MANAGEMENT.resolveModelAttribute(context, model).asStringOrNull());
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                EjbLogger.ROOT_LOGGER.debug("Configuring timers");
                processorTarget.addDeploymentProcessor("ejb3", Phase.PARSE, 13313, (DeploymentUnitProcessor)new TimerServiceAnnotationProcessor());
                processorTarget.addDeploymentProcessor("ejb3", Phase.PARSE, 13312, (DeploymentUnitProcessor)new AroundTimeoutAnnotationParsingProcessor());
                processorTarget.addDeploymentProcessor("ejb3", Phase.POST_MODULE, 1286, (DeploymentUnitProcessor)new TimerMethodMergingProcessor());
                processorTarget.addDeploymentProcessor("ejb3", Phase.POST_MODULE, 1537, (DeploymentUnitProcessor)new TimerServiceDeploymentProcessor(threadPoolName, defaultMetaData));
            }
        }, OperationContext.Stage.RUNTIME);
        if (threadPoolName != null) {
            context.getCapabilityServiceTarget().addCapability(TimerServiceResourceDefinition.TIMER_SERVICE_CAPABILITY, (Service)new TimerValueService()).install();
        }
    }

    private static final class TimerValueService
    implements Service<Timer> {
        private Timer timer;

        private TimerValueService() {
        }

        public synchronized void start(StartContext context) throws StartException {
            this.timer = new Timer();
        }

        public synchronized void stop(StopContext context) {
            this.timer.cancel();
            this.timer = null;
        }

        public synchronized Timer getValue() throws IllegalStateException, IllegalArgumentException {
            return this.timer;
        }
    }
}

