/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.NamedResourceListParseResult;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.DHG;
import org.apache.sshd.common.kex.DHGroupData;
import org.apache.sshd.common.kex.ECDH;
import org.apache.sshd.common.kex.MontgomeryCurve;
import org.apache.sshd.common.kex.XDH;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public enum BuiltinDHFactories implements DHFactory
{
    dhg1("diffie-hellman-group1-sha1"){

        @Override
        public DHG create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty((Object[])params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new DHG((Factory<? extends Digest>)BuiltinDigests.sha1, new BigInteger(DHGroupData.getP1()), new BigInteger(DHGroupData.getG()));
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isDHOakelyGroupSupported((int)1024) && BuiltinDigests.sha1.isSupported();
        }
    }
    ,
    dhg14("diffie-hellman-group14-sha1"){

        @Override
        public DHG create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty((Object[])params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new DHG((Factory<? extends Digest>)BuiltinDigests.sha1, new BigInteger(DHGroupData.getP14()), new BigInteger(DHGroupData.getG()));
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isDHOakelyGroupSupported((int)2048) && BuiltinDigests.sha1.isSupported();
        }
    }
    ,
    dhg14_256("diffie-hellman-group14-sha256"){

        @Override
        public DHG create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty((Object[])params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new DHG((Factory<? extends Digest>)BuiltinDigests.sha256, new BigInteger(DHGroupData.getP14()), new BigInteger(DHGroupData.getG()));
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isDHOakelyGroupSupported((int)2048) && BuiltinDigests.sha256.isSupported();
        }
    }
    ,
    dhg15_512("diffie-hellman-group15-sha512"){

        @Override
        public DHG create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty((Object[])params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new DHG((Factory<? extends Digest>)BuiltinDigests.sha512, new BigInteger(DHGroupData.getP15()), new BigInteger(DHGroupData.getG()));
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isDHOakelyGroupSupported((int)3072) && BuiltinDigests.sha512.isSupported();
        }
    }
    ,
    dhg16_512("diffie-hellman-group16-sha512"){

        @Override
        public DHG create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty((Object[])params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new DHG((Factory<? extends Digest>)BuiltinDigests.sha512, new BigInteger(DHGroupData.getP16()), new BigInteger(DHGroupData.getG()));
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isDHOakelyGroupSupported((int)4096) && BuiltinDigests.sha512.isSupported();
        }
    }
    ,
    dhg17_512("diffie-hellman-group17-sha512"){

        @Override
        public DHG create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty((Object[])params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new DHG((Factory<? extends Digest>)BuiltinDigests.sha512, new BigInteger(DHGroupData.getP17()), new BigInteger(DHGroupData.getG()));
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isDHOakelyGroupSupported((int)6144) && BuiltinDigests.sha512.isSupported();
        }
    }
    ,
    dhg18_512("diffie-hellman-group18-sha512"){

        @Override
        public DHG create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty((Object[])params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new DHG((Factory<? extends Digest>)BuiltinDigests.sha512, new BigInteger(DHGroupData.getP18()), new BigInteger(DHGroupData.getG()));
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isDHOakelyGroupSupported((int)8192) && BuiltinDigests.sha512.isSupported();
        }
    }
    ,
    dhgex("diffie-hellman-group-exchange-sha1"){

        @Override
        public DHG create(Object ... params) throws Exception {
            if (GenericUtils.length((Object[])params) != 2 || !(params[0] instanceof BigInteger) || !(params[1] instanceof BigInteger)) {
                throw new IllegalArgumentException("Bad parameters for " + this.getName());
            }
            return new DHG((Factory<? extends Digest>)BuiltinDigests.sha1, (BigInteger)params[0], (BigInteger)params[1]);
        }

        @Override
        public boolean isGroupExchange() {
            return true;
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isDHGroupExchangeSupported() && BuiltinDigests.sha1.isSupported();
        }
    }
    ,
    dhgex256("diffie-hellman-group-exchange-sha256"){

        @Override
        public AbstractDH create(Object ... params) throws Exception {
            if (GenericUtils.length((Object[])params) != 2 || !(params[0] instanceof BigInteger) || !(params[1] instanceof BigInteger)) {
                throw new IllegalArgumentException("Bad parameters for " + this.getName());
            }
            return new DHG((Factory<? extends Digest>)BuiltinDigests.sha256, (BigInteger)params[0], (BigInteger)params[1]);
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isDHGroupExchangeSupported() && BuiltinDigests.sha256.isSupported();
        }

        @Override
        public boolean isGroupExchange() {
            return true;
        }
    }
    ,
    ecdhp256("ecdh-sha2-nistp256"){

        @Override
        public ECDH create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty((Object[])params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new ECDH(ECCurves.nistp256);
        }

        @Override
        public boolean isSupported() {
            return ECCurves.nistp256.isSupported();
        }
    }
    ,
    ecdhp384("ecdh-sha2-nistp384"){

        @Override
        public ECDH create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty((Object[])params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new ECDH(ECCurves.nistp384);
        }

        @Override
        public boolean isSupported() {
            return ECCurves.nistp384.isSupported();
        }
    }
    ,
    ecdhp521("ecdh-sha2-nistp521"){

        @Override
        public ECDH create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty((Object[])params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new ECDH(ECCurves.nistp521);
        }

        @Override
        public boolean isSupported() {
            return ECCurves.nistp521.isSupported();
        }
    }
    ,
    curve25519("curve25519-sha256"){

        @Override
        public XDH create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty((Object[])params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new XDH(MontgomeryCurve.x25519);
        }

        @Override
        public boolean isSupported() {
            return MontgomeryCurve.x25519.isSupported();
        }
    }
    ,
    curve25519_libssh("curve25519-sha256@libssh.org"){

        @Override
        public XDH create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty((Object[])params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new XDH(MontgomeryCurve.x25519);
        }

        @Override
        public boolean isSupported() {
            return MontgomeryCurve.x25519.isSupported();
        }
    }
    ,
    curve448("curve448-sha512"){

        @Override
        public XDH create(Object ... params) throws Exception {
            if (!GenericUtils.isEmpty((Object[])params)) {
                throw new IllegalArgumentException("No accepted parameters for " + this.getName());
            }
            return new XDH(MontgomeryCurve.x448);
        }

        @Override
        public boolean isSupported() {
            return MontgomeryCurve.x448.isSupported();
        }
    };

    public static final Set<BuiltinDHFactories> VALUES;
    private static final Map<String, DHFactory> EXTENSIONS;
    private final String factoryName;

    private BuiltinDHFactories(String name) {
        this.factoryName = name;
    }

    public final String getName() {
        return this.factoryName;
    }

    public boolean isSupported() {
        return true;
    }

    public final String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExtension(DHFactory extension) {
        String name = Objects.requireNonNull(extension, "No extension provided").getName();
        ValidateUtils.checkTrue((BuiltinDHFactories.fromFactoryName(name) == null ? 1 : 0) != 0, (String)"Extension overrides built-in: %s", (Object)name);
        Map<String, DHFactory> map = EXTENSIONS;
        synchronized (map) {
            ValidateUtils.checkTrue((!EXTENSIONS.containsKey(name) ? 1 : 0) != 0, (String)"Extension overrides existing: %s", (Object)name);
            EXTENSIONS.put(name, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet<DHFactory> getRegisteredExtensions() {
        Map<String, DHFactory> map = EXTENSIONS;
        synchronized (map) {
            return GenericUtils.asSortedSet((Comparator)NamedResource.BY_NAME_COMPARATOR, EXTENSIONS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHFactory unregisterExtension(String name) {
        if (GenericUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        Map<String, DHFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.remove(name);
        }
    }

    public static BuiltinDHFactories fromFactoryName(String name) {
        return (BuiltinDHFactories)NamedResource.findByName((String)name, (Comparator)String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    @Override
    public boolean isGroupExchange() {
        return false;
    }

    public static ParseResult parseDHFactoriesList(String dhList) {
        return BuiltinDHFactories.parseDHFactoriesList(GenericUtils.split((String)dhList, (char)','));
    }

    public static ParseResult parseDHFactoriesList(String ... dhList) {
        return BuiltinDHFactories.parseDHFactoriesList(GenericUtils.isEmpty((Object[])dhList) ? Collections.emptyList() : Arrays.asList(dhList));
    }

    public static ParseResult parseDHFactoriesList(Collection<String> dhList) {
        if (GenericUtils.isEmpty(dhList)) {
            return ParseResult.EMPTY;
        }
        ArrayList<DHFactory> factories = new ArrayList<DHFactory>(dhList.size());
        List<String> unknown = Collections.emptyList();
        for (String name : dhList) {
            DHFactory f = BuiltinDHFactories.resolveFactory(name);
            if (f != null) {
                factories.add(f);
                continue;
            }
            if (unknown.isEmpty()) {
                unknown = new ArrayList<String>();
            }
            unknown.add(name);
        }
        return new ParseResult(factories, unknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHFactory resolveFactory(String name) {
        if (GenericUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        BuiltinDHFactories s = BuiltinDHFactories.fromFactoryName(name);
        if (s != null) {
            return s;
        }
        Map<String, DHFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.get(name);
        }
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinDHFactories.class));
        EXTENSIONS = new TreeMap<String, DHFactory>(String.CASE_INSENSITIVE_ORDER);
    }

    public static final class Constants {
        public static final String DIFFIE_HELLMAN_GROUP1_SHA1 = "diffie-hellman-group1-sha1";
        public static final String DIFFIE_HELLMAN_GROUP14_SHA1 = "diffie-hellman-group14-sha1";
        public static final String DIFFIE_HELLMAN_GROUP14_SHA256 = "diffie-hellman-group14-sha256";
        public static final String DIFFIE_HELLMAN_GROUP15_SHA512 = "diffie-hellman-group15-sha512";
        public static final String DIFFIE_HELLMAN_GROUP16_SHA512 = "diffie-hellman-group16-sha512";
        public static final String DIFFIE_HELLMAN_GROUP17_SHA512 = "diffie-hellman-group17-sha512";
        public static final String DIFFIE_HELLMAN_GROUP18_SHA512 = "diffie-hellman-group18-sha512";
        public static final String DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1 = "diffie-hellman-group-exchange-sha1";
        public static final String DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA256 = "diffie-hellman-group-exchange-sha256";
        public static final String ECDH_SHA2_NISTP256 = "ecdh-sha2-nistp256";
        public static final String ECDH_SHA2_NISTP384 = "ecdh-sha2-nistp384";
        public static final String ECDH_SHA2_NISTP521 = "ecdh-sha2-nistp521";
        public static final String CURVE25519_SHA256 = "curve25519-sha256";
        public static final String CURVE25519_SHA256_LIBSSH = "curve25519-sha256@libssh.org";
        public static final String CURVE448_SHA512 = "curve448-sha512";

        private Constants() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }

    public static final class ParseResult
    extends NamedResourceListParseResult<DHFactory> {
        public static final ParseResult EMPTY = new ParseResult(Collections.emptyList(), Collections.emptyList());

        public ParseResult(List<DHFactory> parsed, List<String> unsupported) {
            super(parsed, unsupported);
        }

        public List<DHFactory> getParsedFactories() {
            return this.getParsedResources();
        }

        public List<String> getUnsupportedFactories() {
            return this.getUnsupportedResources();
        }
    }
}

