/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.validation.impl.AbstractTypeMappingValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.LeafValidators;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationContextType;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationErrorCollector;
import org.hibernate.search.backend.elasticsearch.validation.impl.Validator;
import org.hibernate.search.util.common.impl.CollectionHelper;

class PropertyMappingValidator
extends AbstractTypeMappingValidator<PropertyMapping> {
    private static final List<String> DEFAULT_DATE_FORMAT;

    PropertyMappingValidator() {
    }

    @Override
    protected Validator<PropertyMapping> getPropertyMappingValidator() {
        return this;
    }

    @Override
    public void validate(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
        LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "type", expectedMapping.getType(), actualMapping.getType(), "object");
        List<String> formatDefault = "date".equals(expectedMapping.getType()) ? DEFAULT_DATE_FORMAT : Collections.emptyList();
        LeafValidators.FORMAT.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "format", expectedMapping.getFormat(), actualMapping.getFormat(), formatDefault);
        LeafValidators.EQUAL_DOUBLE.validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "scaling_factor", expectedMapping.getScalingFactor(), actualMapping.getScalingFactor());
        this.validateIndexOptions(errorCollector, expectedMapping, actualMapping);
        LeafValidators.jsonElement(expectedMapping.getType()).validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "null_value", (JsonElement)expectedMapping.getNullValue(), (JsonElement)actualMapping.getNullValue());
        this.validateAnalyzerOptions(errorCollector, expectedMapping, actualMapping);
        LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "term_vector", expectedMapping.getTermVector(), actualMapping.getTermVector(), "no");
        super.validate(errorCollector, expectedMapping, actualMapping);
    }

    private void validateAnalyzerOptions(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
        LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "analyzer", expectedMapping.getAnalyzer(), actualMapping.getAnalyzer(), "default");
        LeafValidators.EQUAL.validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "search_analyzer", expectedMapping.getSearchAnalyzer(), actualMapping.getSearchAnalyzer());
        LeafValidators.EQUAL.validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "normalizer", expectedMapping.getNormalizer(), actualMapping.getNormalizer());
    }

    private void validateIndexOptions(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
        Boolean expectedDocValues;
        Boolean expectedNorms;
        Boolean expectedIndex = expectedMapping.getIndex();
        if (Boolean.TRUE.equals(expectedIndex)) {
            LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "index", expectedIndex, actualMapping.getIndex(), true);
        }
        if (Boolean.TRUE.equals(expectedNorms = expectedMapping.getNorms())) {
            Boolean normsDefault = "text".equals(expectedMapping.getType()) ? Boolean.TRUE : Boolean.FALSE;
            LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "norms", expectedNorms, actualMapping.getNorms(), normsDefault);
        }
        if (Boolean.TRUE.equals(expectedDocValues = expectedMapping.getDocValues())) {
            LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "doc_values", expectedDocValues, actualMapping.getDocValues(), true);
        }
    }

    static {
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("strict_date_optional_time");
        formats.add("epoch_millis");
        DEFAULT_DATE_FORMAT = CollectionHelper.toImmutableList(formats);
    }
}

