/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.SymmetricClusterTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;

public class SymmetricClusterWithDiscoveryTest
extends SymmetricClusterTest {
    protected final String groupAddress = ActiveMQTestBase.getUDPDiscoveryAddress();
    protected final int groupPort = ActiveMQTestBase.getUDPDiscoveryPort();

    @Override
    protected boolean isNetty() {
        return false;
    }

    @Override
    protected void setupCluster() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
    }

    @Override
    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupDiscoveryClusterConnection("cluster0", 0, "dg1", "queues", messageLoadBalancingType, 1, this.isNetty());
        this.setupDiscoveryClusterConnection("cluster1", 1, "dg1", "queues", messageLoadBalancingType, 1, this.isNetty());
        this.setupDiscoveryClusterConnection("cluster2", 2, "dg1", "queues", messageLoadBalancingType, 1, this.isNetty());
        this.setupDiscoveryClusterConnection("cluster3", 3, "dg1", "queues", messageLoadBalancingType, 1, this.isNetty());
        this.setupDiscoveryClusterConnection("cluster4", 4, "dg1", "queues", messageLoadBalancingType, 1, this.isNetty());
    }

    @Override
    protected void setupServers() throws Exception {
        this.setupLiveServerWithDiscovery(0, this.groupAddress, this.groupPort, this.isFileStorage(), this.isNetty(), false);
        this.setupLiveServerWithDiscovery(1, this.groupAddress, this.groupPort, this.isFileStorage(), this.isNetty(), false);
        this.setupLiveServerWithDiscovery(2, this.groupAddress, this.groupPort, this.isFileStorage(), this.isNetty(), false);
        this.setupLiveServerWithDiscovery(3, this.groupAddress, this.groupPort, this.isFileStorage(), this.isNetty(), false);
        this.setupLiveServerWithDiscovery(4, this.groupAddress, this.groupPort, this.isFileStorage(), this.isNetty(), false);
    }

    public void _testStartStopServersWithPauseBeforeRestarting() throws Exception {
        this.doTestStartStopServers(10000L, 3000L);
    }
}

