/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Assert;
import org.junit.Test;

public class MessageTest
extends JMSTestBase {
    private static final long TIMEOUT = 1000L;
    private static final String propName1 = "myprop1";
    private static final String propName2 = "myprop2";
    private static final String propName3 = "myprop3";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamMessageReadsNull() throws Exception {
        try (Connection conn = this.cf.createConnection();){
            Queue queue = this.createQueue("testQueue");
            Session sess = conn.createSession(false, 1);
            MessageProducer prod = sess.createProducer((Destination)queue);
            MessageConsumer cons = sess.createConsumer((Destination)queue);
            conn.start();
            StreamMessage msg = sess.createStreamMessage();
            msg.writeInt(1);
            msg.writeInt(2);
            msg.writeInt(3);
            StreamMessage received = (StreamMessage)this.sendAndConsumeMessage((Message)msg, prod, cons);
            Assert.assertNotNull((Object)received);
            MessageTest.assertEquals((Object)1, (Object)received.readObject());
            MessageTest.assertEquals((Object)2, (Object)received.readObject());
            MessageTest.assertEquals((Object)3, (Object)received.readObject());
            try {
                received.readObject();
                MessageTest.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readBoolean();
                MessageTest.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readByte();
                MessageTest.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readChar();
                MessageTest.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readDouble();
                MessageTest.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readFloat();
                MessageTest.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readInt();
                MessageTest.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readLong();
                MessageTest.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readShort();
                MessageTest.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readString();
                MessageTest.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testNullProperties() throws Exception {
        this.conn = this.cf.createConnection();
        Queue queue = this.createQueue("testQueue");
        Session sess = this.conn.createSession(false, 1);
        MessageProducer prod = sess.createProducer((Destination)queue);
        MessageConsumer cons = sess.createConsumer((Destination)queue);
        this.conn.start();
        Message msg = sess.createMessage();
        msg.setStringProperty("Test", "SomeValue");
        MessageTest.assertEquals((Object)"SomeValue", (Object)msg.getStringProperty("Test"));
        msg.setStringProperty("Test", null);
        MessageTest.assertEquals(null, (Object)msg.getStringProperty("Test"));
        msg.setObjectProperty(propName1, null);
        msg.setObjectProperty("JMSXGroupID", null);
        msg.setObjectProperty("JMSXUserID", null);
        msg.setStringProperty(propName2, null);
        msg.getStringProperty(propName1);
        msg.setStringProperty("Test", null);
        Message received = this.sendAndConsumeMessage(msg, prod, cons);
        Assert.assertNotNull((Object)received);
        this.checkProperties(received);
    }

    private void checkProperties(Message message) throws Exception {
        Assert.assertNull((Object)message.getObjectProperty(propName1));
        Assert.assertNull((Object)message.getStringProperty(propName1));
        Assert.assertNull((Object)message.getStringProperty(propName2));
        Assert.assertNull((Object)message.getObjectProperty(propName2));
        Assert.assertNull((Object)message.getStringProperty(propName3));
        Assert.assertNull((Object)message.getObjectProperty(propName3));
        try {
            this.instanceLog.debug((Object)message.getIntProperty(propName1));
            Assert.fail((String)"Should throw exception");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.instanceLog.debug((Object)message.getShortProperty(propName1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.instanceLog.debug((Object)message.getByteProperty(propName1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Assert.assertEquals((Object)false, (Object)message.getBooleanProperty(propName1));
        try {
            this.instanceLog.debug((Object)message.getLongProperty(propName1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.instanceLog.debug((Object)Float.valueOf(message.getFloatProperty(propName1)));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.instanceLog.debug((Object)message.getDoubleProperty(propName1));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShouldNotThrowException() throws Exception {
        Connection conn = null;
        this.createTopic(true, "Topic1");
        try {
            conn = this.cf.createConnection();
            conn.start();
            Session session1 = conn.createSession(false, 2);
            session1.createConsumer((Destination)ActiveMQJMSClient.createTopic((String)"Topic1"));
            Session session2 = conn.createSession(false, 2);
            session2.createConsumer((Destination)ActiveMQJMSClient.createTopic((String)"*"));
            session1.close();
            session2.close();
            Session session3 = conn.createSession(false, 2);
            MessageConsumer cons = session3.createConsumer((Destination)ActiveMQJMSClient.createTopic((String)"Topic1"));
            MessageProducer prod = session3.createProducer((Destination)ActiveMQJMSClient.createTopic((String)"Topic1"));
            MessageConsumer consGeral = session3.createConsumer((Destination)ActiveMQJMSClient.createTopic((String)"*"));
            prod.send((Message)session3.createTextMessage("hello"));
            MessageTest.assertNotNull((Object)cons.receive(5000L));
            MessageTest.assertNotNull((Object)consGeral.receive(5000L));
            this.createTopic(true, "Topic2");
            MessageProducer prod2 = session3.createProducer((Destination)ActiveMQJMSClient.createTopic((String)"Topic2"));
            prod2.send((Message)session3.createTextMessage("test"));
            MessageTest.assertNull((Object)cons.receiveNoWait());
            MessageTest.assertNotNull((Object)consGeral.receive(5000L));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    private Message sendAndConsumeMessage(Message msg, MessageProducer prod, MessageConsumer cons) throws Exception {
        prod.send(msg);
        Message received = cons.receive(1000L);
        return received;
    }
}

