/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.largemessage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.DeflaterReader;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class LargeMessageTestBase
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(LargeMessageTestBase.class);
    protected final SimpleString ADDRESS = new SimpleString("SimpleAddress");
    protected StoreConfiguration.StoreType storeType;

    public LargeMessageTestBase(StoreConfiguration.StoreType storeType) {
        this.storeType = storeType;
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.storeType == StoreConfiguration.StoreType.DATABASE) {
            this.destroyTables(Arrays.asList("BINDINGS", "LARGE_MESSAGE", "MESSAGE", "NODE_MANAGER_STORE"));
        }
    }

    @Parameterized.Parameters(name="storeType={0}")
    public static Collection<Object[]> data() {
        Object[][] params = new Object[][]{{StoreConfiguration.StoreType.FILE}, {StoreConfiguration.StoreType.DATABASE}};
        return Arrays.asList(params);
    }

    protected void testChunks(boolean isXA, boolean restartOnXA, boolean rollbackFirstSend, boolean useStreamOnConsume, boolean realFiles, boolean preAck, boolean sendingBlocking, boolean testBrowser, boolean useMessageConsumer, int numberOfMessages, long numberOfBytes, int waitOnConsumer, long delayDelivery) throws Exception {
        this.testChunks(isXA, restartOnXA, rollbackFirstSend, useStreamOnConsume, realFiles, preAck, sendingBlocking, testBrowser, useMessageConsumer, numberOfMessages, numberOfBytes, waitOnConsumer, delayDelivery, -1, 10240);
    }

    protected void testChunks(boolean isXA, boolean restartOnXA, boolean rollbackFirstSend, final boolean useStreamOnConsume, boolean realFiles, final boolean preAck, boolean sendingBlocking, boolean testBrowser, boolean useMessageConsumer, int numberOfMessages, final long numberOfBytes, int waitOnConsumer, final long delayDelivery, int producerWindow, int minSize) throws Exception {
        this.clearDataRecreateServerDirs();
        Configuration configuration = this.storeType == StoreConfiguration.StoreType.DATABASE ? this.createDefaultJDBCConfig(true) : this.createDefaultConfig(false);
        ActiveMQServer server = this.createServer(realFiles, configuration);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        try {
            int iteration;
            Xid[] xids;
            if (sendingBlocking) {
                locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
            }
            if (producerWindow > 0) {
                locator.setConfirmationWindowSize(producerWindow);
            }
            locator.setMinLargeMessageSize(minSize);
            ClientSessionFactory sf = locator.createSessionFactory();
            XidImpl xid = null;
            ClientSession session = sf.createSession(null, null, isXA, false, false, preAck, 0);
            if (isXA) {
                xid = this.newXID();
                session.start((Xid)xid, 0);
            }
            session.createQueue(new QueueConfiguration(this.ADDRESS));
            ClientProducer producer = session.createProducer(this.ADDRESS);
            if (rollbackFirstSend) {
                this.sendMessages(numberOfMessages, numberOfBytes, delayDelivery, session, producer);
                if (isXA) {
                    session.end((Xid)xid, 0x4000000);
                    session.prepare((Xid)xid);
                    session.close();
                    if (realFiles && restartOnXA) {
                        server.stop();
                        server.start();
                        sf = locator.createSessionFactory();
                    }
                    session = sf.createSession(null, null, isXA, false, false, preAck, 0);
                    xids = session.recover(0x1000000);
                    Assert.assertEquals((long)1L, (long)xids.length);
                    Assert.assertEquals((Object)xid, (Object)xids[0]);
                    session.rollback((Xid)xid);
                    producer = session.createProducer(this.ADDRESS);
                    xid = this.newXID();
                    session.start((Xid)xid, 0);
                } else {
                    session.rollback();
                }
                this.validateNoFilesOnLargeDir();
            }
            this.sendMessages(numberOfMessages, numberOfBytes, delayDelivery, session, producer);
            if (isXA) {
                session.end((Xid)xid, 0x4000000);
                session.prepare((Xid)xid);
                session.close();
                if (realFiles && restartOnXA) {
                    server.stop();
                    server.start();
                    sf = locator.createSessionFactory();
                }
                session = sf.createSession(null, null, isXA, false, false, preAck, 0);
                xids = session.recover(0x1000000);
                Assert.assertEquals((long)1L, (long)xids.length);
                Assert.assertEquals((Object)xid, (Object)xids[0]);
                producer = session.createProducer(this.ADDRESS);
                session.commit((Xid)xid, false);
                xid = this.newXID();
                session.start((Xid)xid, 0);
            } else {
                session.commit();
            }
            session.close();
            if (realFiles) {
                server.stop();
                server = this.createServer(realFiles, configuration);
                server.start();
                sf = locator.createSessionFactory();
            }
            session = sf.createSession(null, null, isXA, false, false, preAck, 0);
            if (isXA) {
                xid = this.newXID();
                session.start((Xid)xid, 0);
            }
            ClientConsumer consumer = null;
            int n = iteration = testBrowser ? 0 : 1;
            while (iteration < 2) {
                session.stop();
                consumer = session.createConsumer(this.ADDRESS, null, iteration == 0);
                if (useMessageConsumer) {
                    final CountDownLatch latchDone = new CountDownLatch(numberOfMessages);
                    final AtomicInteger errors = new AtomicInteger(0);
                    MessageHandler handler = new MessageHandler(){
                        int msgCounter;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onMessage(ClientMessage message) {
                            try {
                                if (delayDelivery > 0L) {
                                    long originalTime = (Long)message.getObjectProperty(new SimpleString("original-time"));
                                    Assert.assertTrue((String)(System.currentTimeMillis() - originalTime + "<" + delayDelivery), (System.currentTimeMillis() - originalTime >= delayDelivery ? (byte)1 : 0) != 0);
                                }
                                if (!preAck) {
                                    message.acknowledge();
                                }
                                Assert.assertNotNull((Object)message);
                                if (delayDelivery <= 0L) {
                                    Assert.assertEquals((long)this.msgCounter, (long)((Integer)message.getObjectProperty(new SimpleString("counter-message"))).intValue());
                                }
                                if (useStreamOnConsume) {
                                    final AtomicLong bytesRead = new AtomicLong(0L);
                                    message.saveToOutputStream(new OutputStream(){

                                        @Override
                                        public void write(byte[] b) throws IOException {
                                            if (b[0] == ActiveMQTestBase.getSamplebyte((long)bytesRead.get())) {
                                                bytesRead.addAndGet(b.length);
                                                log.debug((Object)("Read position " + bytesRead.get() + " on consumer"));
                                            } else {
                                                log.warn((Object)("Received invalid packet at position " + bytesRead.get()));
                                            }
                                        }

                                        @Override
                                        public void write(int b) throws IOException {
                                            if (b == ActiveMQTestBase.getSamplebyte((long)bytesRead.get())) {
                                                bytesRead.incrementAndGet();
                                            } else {
                                                log.warn((Object)"byte not as expected!");
                                            }
                                        }
                                    });
                                    Assert.assertEquals((long)numberOfBytes, (long)bytesRead.get());
                                } else {
                                    ActiveMQBuffer buffer = message.getBodyBuffer();
                                    buffer.resetReaderIndex();
                                    for (long b = 0L; b < numberOfBytes; ++b) {
                                        if (b % 0x100000L == 0L) {
                                            log.debug((Object)("Read " + b + " bytes"));
                                        }
                                        Assert.assertEquals((long)ActiveMQTestBase.getSamplebyte((long)b), (long)buffer.readByte());
                                    }
                                    try {
                                        buffer.readByte();
                                        Assert.fail((String)"Supposed to throw an exception");
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                log.warn((Object)"Got an error", e);
                                errors.incrementAndGet();
                            }
                            finally {
                                latchDone.countDown();
                                ++this.msgCounter;
                            }
                        }
                    };
                    session.start();
                    consumer.setMessageHandler(handler);
                    Assert.assertTrue((boolean)latchDone.await(waitOnConsumer, TimeUnit.MILLISECONDS));
                    Assert.assertEquals((long)0L, (long)errors.get());
                } else {
                    session.start();
                    for (int i = 0; i < numberOfMessages; ++i) {
                        ClientMessage message = consumer.receive((long)waitOnConsumer + delayDelivery);
                        Assert.assertNotNull((Object)message);
                        if (delayDelivery > 0L) {
                            long originalTime = (Long)message.getObjectProperty(new SimpleString("original-time"));
                            Assert.assertTrue((String)(System.currentTimeMillis() - originalTime + "<" + delayDelivery), (System.currentTimeMillis() - originalTime >= delayDelivery ? (byte)1 : 0) != 0);
                        }
                        if (!preAck) {
                            message.acknowledge();
                        }
                        Assert.assertNotNull((Object)message);
                        if (delayDelivery <= 0L) {
                            Assert.assertEquals((long)i, (long)((Integer)message.getObjectProperty(new SimpleString("counter-message"))).intValue());
                        }
                        if (useStreamOnConsume) {
                            final AtomicLong bytesRead = new AtomicLong(0L);
                            message.saveToOutputStream(new OutputStream(){

                                @Override
                                public void write(byte[] b) throws IOException {
                                    if (b.length > 0) {
                                        if (b[0] == ActiveMQTestBase.getSamplebyte((long)bytesRead.get())) {
                                            bytesRead.addAndGet(b.length);
                                        } else {
                                            log.warn((Object)("Received invalid packet at position " + bytesRead.get()));
                                        }
                                    }
                                }

                                @Override
                                public void write(int b) throws IOException {
                                    if (bytesRead.get() % 0x100000L == 0L) {
                                        log.debug((Object)("Read " + bytesRead.get() + " bytes"));
                                    }
                                    if (b == 97) {
                                        bytesRead.incrementAndGet();
                                    } else {
                                        log.warn((Object)"byte not as expected!");
                                    }
                                }
                            });
                            Assert.assertEquals((long)numberOfBytes, (long)bytesRead.get());
                            continue;
                        }
                        ActiveMQBuffer buffer = message.getBodyBuffer();
                        buffer.resetReaderIndex();
                        for (long b = 0L; b < numberOfBytes; ++b) {
                            if (b % 0x100000L == 0L) {
                                log.debug((Object)("Read " + b + " bytes"));
                            }
                            Assert.assertEquals((long)ActiveMQTestBase.getSamplebyte((long)b), (long)buffer.readByte());
                        }
                    }
                }
                consumer.close();
                if (iteration == 0) {
                    if (isXA) {
                        session.end((Xid)xid, 0x4000000);
                        session.rollback((Xid)xid);
                        xid = this.newXID();
                        session.start((Xid)xid, 0);
                    } else {
                        session.rollback();
                    }
                } else if (isXA) {
                    session.end((Xid)xid, 0x4000000);
                    session.commit((Xid)xid, true);
                    xid = this.newXID();
                    session.start((Xid)xid, 0);
                } else {
                    session.commit();
                }
                ++iteration;
            }
            session.close();
            Assert.assertEquals((long)0L, (long)((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()).getDeliveringCount());
            Assert.assertEquals((long)0L, (long)((Queue)server.getPostOffice().getBinding(this.ADDRESS).getBindable()).getMessageCount());
            this.validateNoFilesOnLargeDir();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            locator.close();
            try {
                server.stop();
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
        }
    }

    private void sendMessages(int numberOfMessages, long numberOfBytes, long delayDelivery, ClientSession session, ClientProducer producer) throws Exception {
        log.debug((Object)("NumberOfBytes = " + numberOfBytes));
        for (int i = 0; i < numberOfMessages; ++i) {
            ClientMessage message = session.createMessage(true);
            if (numberOfBytes > 0x100000L || i % 2 == 0) {
                log.debug((Object)("Sending message (stream)" + i));
                message.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream((long)numberOfBytes));
            } else {
                log.debug((Object)("Sending message (array)" + i));
                byte[] bytes = new byte[(int)numberOfBytes];
                for (int j = 0; j < bytes.length; ++j) {
                    bytes[j] = ActiveMQTestBase.getSamplebyte((long)j);
                }
                message.getBodyBuffer().writeBytes(bytes);
            }
            message.putIntProperty(new SimpleString("counter-message"), i);
            if (delayDelivery > 0L) {
                long time = System.currentTimeMillis();
                message.putLongProperty(new SimpleString("original-time"), time);
                message.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, time + delayDelivery);
                producer.send((Message)message);
                continue;
            }
            producer.send((Message)message);
        }
    }

    protected ActiveMQBuffer createLargeBuffer(int numberOfIntegers) {
        ActiveMQBuffer body = ActiveMQBuffers.fixedBuffer((int)(4 * numberOfIntegers));
        for (int i = 0; i < numberOfIntegers; ++i) {
            body.writeInt(i);
        }
        return body;
    }

    protected ClientMessage createLargeClientMessageStreaming(ClientSession session, int numberOfBytes) throws Exception {
        return this.createLargeClientMessageStreaming(session, numberOfBytes, true);
    }

    protected ClientMessage createLargeClientMessage(ClientSession session, byte[] buffer, boolean durable) throws Exception {
        ClientMessage msgs = session.createMessage(durable);
        msgs.getBodyBuffer().writeBytes(buffer);
        return msgs;
    }

    protected ClientMessage createLargeClientMessageStreaming(ClientSession session, long numberOfBytes, boolean persistent) throws Exception {
        ClientMessage clientMessage = session.createMessage(persistent);
        clientMessage.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream((long)numberOfBytes));
        return clientMessage;
    }

    protected void readMessage(ClientSession session, SimpleString queueToRead, int numberOfBytes) throws ActiveMQException, IOException {
        session.start();
        ClientConsumer consumer = session.createConsumer(queueToRead);
        ClientMessage clientMessage = consumer.receive(5000L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        session.commit();
        consumer.close();
    }

    protected OutputStream createFakeOutputStream() throws Exception {
        return new OutputStream(){
            private boolean closed = false;
            private int count;

            @Override
            public void close() throws IOException {
                super.close();
                this.closed = true;
            }

            @Override
            public void write(int b) throws IOException {
                if (this.count++ % 1024 * 1024 == 0) {
                    log.debug((Object)("OutputStream received " + this.count + " bytes"));
                }
                if (this.closed) {
                    throw new IOException("Stream was closed");
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adjustLargeCompression(boolean regular, TestLargeMessageInputStream stream, int step) throws IOException {
        int absoluteStep = Math.abs(step);
        while (true) {
            DeflaterReader compressor = new DeflaterReader((InputStream)stream, new AtomicLong());
            try {
                byte[] buffer = new byte[52400];
                int totalCompressed = 0;
                int n = compressor.read(buffer);
                while (n != -1) {
                    totalCompressed += n;
                    n = compressor.read(buffer);
                }
                if (regular && totalCompressed < stream.getMinLarge()) {
                    stream.resetAdjust(0);
                    break;
                }
                if (!regular && totalCompressed > stream.getMinLarge()) {
                    stream.resetAdjust(0);
                    break;
                }
                stream.resetAdjust(regular ? -absoluteStep : absoluteStep);
                continue;
            }
            finally {
                compressor.close();
                continue;
            }
            break;
        }
    }

    public static class TestLargeMessageInputStream
    extends InputStream {
        private final int minLarge;
        private int size;
        private int pos;
        private boolean random;

        public TestLargeMessageInputStream(int minLarge) {
            this(minLarge, false);
        }

        public TestLargeMessageInputStream(int minLarge, boolean random) {
            this.pos = 0;
            this.minLarge = minLarge;
            this.size = minLarge + 1024;
            this.random = random;
        }

        public int getChar(int index) {
            if (this.random) {
                Random r = new Random();
                return 65 + r.nextInt(26);
            }
            return 65 + index % 26;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public TestLargeMessageInputStream(TestLargeMessageInputStream other) {
            this.minLarge = other.minLarge;
            this.size = other.size;
            this.pos = other.pos;
        }

        public int getSize() {
            return this.size;
        }

        public int getMinLarge() {
            return this.minLarge;
        }

        @Override
        public int read() throws IOException {
            if (this.pos == this.size) {
                return -1;
            }
            ++this.pos;
            return this.getChar(this.pos - 1);
        }

        public void resetAdjust(int step) {
            this.size += step;
            if (this.size <= this.minLarge) {
                throw new IllegalStateException("Couldn't adjust anymore, size smaller than minLarge " + this.minLarge);
            }
            this.pos = 0;
        }

        public TestLargeMessageInputStream clone() {
            return new TestLargeMessageInputStream(this);
        }

        public char[] toArray() throws IOException {
            char[] result = new char[this.size];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (char)this.read();
            }
            return result;
        }
    }
}

