/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.cli.commands.tools.journal.DecodeJournal;
import org.apache.activemq.artemis.cli.commands.tools.journal.EncodeJournal;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Ignore;
import org.junit.Test;

public class ExportFormatTest
extends ActiveMQTestBase {
    String bindingsFile = "#File,JournalFileImpl: (activemq-bindings-1.bindings id = 1, recordID = 1)\noperation@AddRecord,id@1,userRecordType@24,length@8,isUpdate@false,compactCount@0,data@AAAAAH____8=\noperation@AddRecordTX,txID@2,id@3,userRecordType@21,length@43,isUpdate@false,compactCount@0,data@AAAABEEAMQAAAAAEQQAxAAABAAAAFHUAcwBlAHIAPQBuAHUAbABsADsAAA==\noperation@Commit,txID@2,numberOfRecords@1\noperation@AddRecord,id@20,userRecordType@24,length@8,isUpdate@false,compactCount@0,data@AAAAAAAAABQ=\n#File,JournalFileImpl: (activemq-bindings-2.bindings id = 2, recordID = 2)";
    String journalFile = "#File,JournalFileImpl: (activemq-data-1.amq id = 1, recordID = 1)\noperation@AddRecordTX,txID@0,id@7,userRecordType@45,length@83,isUpdate@false,compactCount@0,data@AQAAAAAAAAAHAQAAAARBADEAAAAAPQAAAA0AAAAAAAAABwEAAAAEQQAxAAAAAQAAAAAAAAAAAAABWpf6WFoEAQAAAAEAAAAGawBlAHkABgAAAAA=\noperation@UpdateTX,txID@0,id@7,userRecordType@32,length@8,isUpdate@true,compactCount@0,data@AAAAAAAAAAM=\noperation@AddRecordTX,txID@0,id@8,userRecordType@45,length@83,isUpdate@false,compactCount@0,data@AQAAAAAAAAAIAQAAAARBADEAAAAAPQAAAA0AAAAAAAAACAEAAAAEQQAxAAAAAQAAAAAAAAAAAAABWpf6WF4EAQAAAAEAAAAGawBlAHkABgAAAAE=\noperation@UpdateTX,txID@0,id@8,userRecordType@32,length@8,isUpdate@true,compactCount@0,data@AAAAAAAAAAM=\noperation@AddRecordTX,txID@0,id@9,userRecordType@45,length@83,isUpdate@false,compactCount@0,data@AQAAAAAAAAAJAQAAAARBADEAAAAAPQAAAA0AAAAAAAAACQEAAAAEQQAxAAAAAQAAAAAAAAAAAAABWpf6WF4EAQAAAAEAAAAGawBlAHkABgAAAAI=\noperation@UpdateTX,txID@0,id@9,userRecordType@32,length@8,isUpdate@true,compactCount@0,data@AAAAAAAAAAM=\noperation@AddRecordTX,txID@0,id@10,userRecordType@45,length@83,isUpdate@false,compactCount@0,data@AQAAAAAAAAAKAQAAAARBADEAAAAAPQAAAA0AAAAAAAAACgEAAAAEQQAxAAAAAQAAAAAAAAAAAAABWpf6WF8EAQAAAAEAAAAGawBlAHkABgAAAAM=\noperation@UpdateTX,txID@0,id@10,userRecordType@32,length@8,isUpdate@true,compactCount@0,data@AAAAAAAAAAM=\noperation@AddRecordTX,txID@0,id@11,userRecordType@45,length@83,isUpdate@false,compactCount@0,data@AQAAAAAAAAALAQAAAARBADEAAAAAPQAAAA0AAAAAAAAACwEAAAAEQQAxAAAAAQAAAAAAAAAAAAABWpf6WF8EAQAAAAEAAAAGawBlAHkABgAAAAQ=\noperation@UpdateTX,txID@0,id@11,userRecordType@32,length@8,isUpdate@true,compactCount@0,data@AAAAAAAAAAM=\noperation@Commit,txID@0,numberOfRecords@10\noperation@AddRecord,id@15,userRecordType@45,length@83,isUpdate@false,compactCount@0,data@AQAAAAAAAAAPAQAAAARBADEAAAAAPQAAAA0AAAAAAAAADwEAAAAEQQAxAAAAAQAAAAAAAAAAAAABWpf6WLAEAQAAAAEAAAAGawBlAHkABgAAAAU=\noperation@Update,id@15,userRecordType@32,length@8,isUpdate@true,compactCount@0,data@AAAAAAAAAAM=\noperation@AddRecord,id@16,userRecordType@45,length@83,isUpdate@false,compactCount@0,data@AQAAAAAAAAAQAQAAAARBADEAAAAAPQAAAA0AAAAAAAAAEAEAAAAEQQAxAAAAAQAAAAAAAAAAAAABWpf6WLIEAQAAAAEAAAAGawBlAHkABgAAAAY=\noperation@Update,id@16,userRecordType@32,length@8,isUpdate@true,compactCount@0,data@AAAAAAAAAAM=\noperation@AddRecord,id@17,userRecordType@45,length@83,isUpdate@false,compactCount@0,data@AQAAAAAAAAARAQAAAARBADEAAAAAPQAAAA0AAAAAAAAAEQEAAAAEQQAxAAAAAQAAAAAAAAAAAAABWpf6WLgEAQAAAAEAAAAGawBlAHkABgAAAAc=\noperation@Update,id@17,userRecordType@32,length@8,isUpdate@true,compactCount@0,data@AAAAAAAAAAM=\noperation@AddRecord,id@18,userRecordType@45,length@83,isUpdate@false,compactCount@0,data@AQAAAAAAAAASAQAAAARBADEAAAAAPQAAAA0AAAAAAAAAEgEAAAAEQQAxAAAAAQAAAAAAAAAAAAABWpf6WLwEAQAAAAEAAAAGawBlAHkABgAAAAg=\noperation@Update,id@18,userRecordType@32,length@8,isUpdate@true,compactCount@0,data@AAAAAAAAAAM=\noperation@AddRecord,id@19,userRecordType@45,length@83,isUpdate@false,compactCount@0,data@AQAAAAAAAAATAQAAAARBADEAAAAAPQAAAA0AAAAAAAAAEwEAAAAEQQAxAAAAAQAAAAAAAAAAAAABWpf6WL4EAQAAAAEAAAAGawBlAHkABgAAAAk=\noperation@Update,id@19,userRecordType@32,length@8,isUpdate@true,compactCount@0,data@AAAAAAAAAAM=\n#File,JournalFileImpl: (activemq-data-2.amq id = 2, recordID = 2)";

    @Test
    @Ignore
    public void testCreateFormat() throws Exception {
        ClientMessage msg;
        int i;
        ActiveMQServer server = this.createServer(true);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = factory.createSession(false, false, false);
        session.createQueue(new QueueConfiguration("A1"));
        ClientProducer producer = session.createProducer("A1");
        for (i = 0; i < 5; ++i) {
            msg = session.createMessage(true);
            msg.putIntProperty("key", i);
            producer.send((Message)msg);
        }
        session.commit();
        session.close();
        session = factory.createSession(false, true, true);
        producer = session.createProducer("A1");
        for (i = 5; i < 10; ++i) {
            msg = session.createMessage(true);
            msg.putIntProperty("key", i);
            producer.send((Message)msg);
        }
        locator.close();
        server.stop();
        System.out.println();
        System.out.println("copy & paste the following as bindingsFile:");
        EncodeJournal.exportJournal((String)server.getConfiguration().getBindingsLocation().getAbsolutePath(), (String)"activemq-bindings", (String)"bindings", (int)2, (int)0x100000, (PrintStream)System.out);
        System.out.println();
        System.out.println("copy & paste the following as dataFile:");
        EncodeJournal.exportJournal((String)server.getConfiguration().getJournalLocation().getAbsolutePath(), (String)"activemq-data", (String)"amq", (int)2, (int)102400, (PrintStream)System.out);
    }

    @Test
    public void testConsumeFromFormat() throws Exception {
        ActiveMQServer server = this.createServer(true);
        DecodeJournal.importJournal((String)server.getConfiguration().getJournalLocation().getAbsolutePath(), (String)"activemq-data", (String)"amq", (int)2, (int)102400, (Reader)new StringReader(this.journalFile));
        DecodeJournal.importJournal((String)server.getConfiguration().getBindingsLocation().getAbsolutePath(), (String)"activemq-bindings", (String)"bindings", (int)2, (int)0x100000, (Reader)new StringReader(this.bindingsFile));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = factory.createSession();
        session.start();
        ClientConsumer consumer = session.createConsumer("A1");
        for (int i = 0; i < 10; ++i) {
            ClientMessage msg = consumer.receive(5000L);
            ExportFormatTest.assertNotNull((Object)msg);
            msg.acknowledge();
            ExportFormatTest.assertEquals((long)i, (long)msg.getIntProperty("key").intValue());
        }
        session.commit();
    }
}

