/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ra;

import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ResourceAdapter;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactoryImpl;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionManager;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.service.extensions.ServiceUtils;
import org.apache.activemq.artemis.tests.integration.ra.ActiveMQRATestBase;
import org.apache.activemq.artemis.tests.integration.ra.DummyTransaction;
import org.apache.activemq.artemis.tests.integration.ra.DummyTransactionManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class IgnoreJTATest
extends ActiveMQRATestBase {
    protected ActiveMQResourceAdapter resourceAdapter;
    protected ActiveMQRAConnectionFactory qraConnectionFactory;
    protected ActiveMQRAManagedConnectionFactory mcf;
    ActiveMQRAConnectionManager qraConnectionManager = new ActiveMQRAConnectionManager();

    @Override
    @Before
    public void setUp() throws Exception {
        this.useDummyTransactionManager();
        super.setUp();
        this.resourceAdapter = new ActiveMQResourceAdapter();
        this.resourceAdapter.setEntries("[\"java://jmsXA\"]");
        this.resourceAdapter.setConnectorClassName(InVMConnectorFactory.class.getName());
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        this.resourceAdapter.start((BootstrapContext)ctx);
        this.mcf = new ActiveMQRAManagedConnectionFactory();
        this.mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        this.qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(this.mcf, (ConnectionManager)this.qraConnectionManager);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        ((DummyTransactionManager)ServiceUtils.getTransactionManager()).tx = null;
        if (this.resourceAdapter != null) {
            this.resourceAdapter.stop();
        }
        this.qraConnectionManager.stop();
        super.tearDown();
    }

    @Test(expected=IllegalStateException.class)
    public void testIgnoreJTA() throws Exception {
        this.testSendAndReceive(true);
    }

    @Test
    public void testDontIgnoreJTA() throws Exception {
        this.testSendAndReceive(false);
    }

    @Test
    public void testDefaultIgnoreJTA() throws Exception {
        this.testSendAndReceive(null);
    }

    private void testSendAndReceive(Boolean ignoreJTA) throws Exception {
        this.setDummyTX();
        this.setupDLQ(10);
        this.resourceAdapter = this.newResourceAdapter();
        if (ignoreJTA != null) {
            this.resourceAdapter.setIgnoreJTA(ignoreJTA);
        }
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        this.resourceAdapter.start((BootstrapContext)ctx);
        ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
        mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)this.qraConnectionManager);
        QueueConnection queueConnection = qraConnectionFactory.createQueueConnection();
        Session s = queueConnection.createSession(true, 1);
        Queue q = ActiveMQJMSClient.createQueue((String)"mdbQueue");
        MessageProducer mp = s.createProducer((Destination)q);
        MessageConsumer consumer = s.createConsumer((Destination)q);
        TextMessage message = s.createTextMessage("test");
        mp.send((Message)message);
        s.commit();
        queueConnection.start();
        TextMessage textMessage = (TextMessage)consumer.receive(1000L);
        IgnoreJTATest.assertNotNull((Object)textMessage);
        IgnoreJTATest.assertEquals((Object)textMessage.getText(), (Object)"test");
        s.rollback();
        textMessage = (TextMessage)consumer.receive(1000L);
        IgnoreJTATest.assertNotNull((Object)textMessage);
        IgnoreJTATest.assertEquals((Object)textMessage.getText(), (Object)"test");
        s.commit();
    }

    private void setDummyTX() {
        ((DummyTransactionManager)ServiceUtils.getTransactionManager()).tx = new DummyTransaction();
    }
}

