/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.routing.KeyResolver;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.core.server.routing.caches.Cache;
import org.apache.activemq.artemis.core.server.routing.policies.Policy;
import org.apache.activemq.artemis.core.server.routing.pools.Pool;
import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.apache.activemq.artemis.core.server.routing.targets.TargetResult;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.jboss.logging.Logger;

public class ConnectionRouter
implements ActiveMQComponent {
    private static final Logger logger = Logger.getLogger(ConnectionRouter.class);
    public static final String CLIENT_ID_PREFIX = "$.artemis.internal.router.client.";
    private final String name;
    private final KeyType keyType;
    private final KeyResolver keyResolver;
    private final TargetResult localTarget;
    private volatile Pattern localTargetFilter;
    private final Pool pool;
    private final Policy policy;
    private final Cache cache;
    private volatile boolean started = false;

    public String getName() {
        return this.name;
    }

    public KeyType getKey() {
        return this.keyType;
    }

    public KeyResolver getKeyResolver() {
        return this.keyResolver;
    }

    public Target getLocalTarget() {
        return this.localTarget.getTarget();
    }

    public String getLocalTargetFilter() {
        return this.localTargetFilter != null ? this.localTargetFilter.pattern() : null;
    }

    public void setLocalTargetFilter(String regExp) {
        this.localTargetFilter = regExp == null || regExp.trim().isEmpty() ? null : Pattern.compile(regExp);
    }

    public Pool getPool() {
        return this.pool;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public Cache getCache() {
        return this.cache;
    }

    public boolean isStarted() {
        return this.started;
    }

    public ConnectionRouter(String name, KeyType keyType, String targetKeyFilter, Target localTarget, String localTargetFilter, Cache cache, Pool pool, Policy policy) {
        this.name = name;
        this.keyType = keyType;
        this.keyResolver = new KeyResolver(keyType, targetKeyFilter);
        this.localTarget = new TargetResult(localTarget);
        this.localTargetFilter = localTargetFilter != null ? Pattern.compile(localTargetFilter) : null;
        this.pool = pool;
        this.policy = policy;
        this.cache = cache;
    }

    public void start() throws Exception {
        if (this.cache != null) {
            this.cache.start();
        }
        if (this.pool != null) {
            this.pool.start();
        }
        this.started = true;
    }

    public void stop() throws Exception {
        this.started = false;
        if (this.pool != null) {
            this.pool.stop();
        }
        if (this.cache != null) {
            this.cache.stop();
        }
    }

    public TargetResult getTarget(Connection connection, String clientID, String username) {
        if (clientID != null && clientID.startsWith(CLIENT_ID_PREFIX)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The clientID [" + clientID + "] starts with ConnectionRouter.CLIENT_ID_PREFIX"));
            }
            return this.localTarget;
        }
        return this.getTarget(this.keyResolver.resolve(connection, clientID, username));
    }

    public TargetResult getTarget(String key) {
        Target target;
        if (this.policy != null && !"NULL".equals(key)) {
            key = this.policy.transformKey(key);
        }
        if (this.localTargetFilter != null && this.localTargetFilter.matcher(key).matches()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The " + this.keyType + "[" + key + "] matches the localTargetFilter " + this.localTargetFilter.pattern()));
            }
            return this.localTarget;
        }
        if (this.policy == null || this.pool == null) {
            return TargetResult.REFUSED_USE_ANOTHER_RESULT;
        }
        TargetResult result = null;
        if (this.cache != null) {
            String nodeId = this.cache.get(key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The cache returns target [" + nodeId + "] for " + this.keyType + "[" + key + "]"));
            }
            if (nodeId != null) {
                target = this.pool.getReadyTarget(nodeId);
                if (target != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("The target [" + nodeId + "] is ready for " + this.keyType + "[" + key + "]"));
                    }
                    return new TargetResult(target);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The target [" + nodeId + "] is not ready for " + this.keyType + "[" + key + "]"));
                }
            }
        }
        List<Target> targets = this.pool.getTargets();
        target = this.policy.selectTarget(targets, key);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The policy selects [" + target + "] from " + targets + " for " + this.keyType + "[" + key + "]"));
        }
        if (target != null) {
            result = new TargetResult(target);
            if (this.cache != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Caching " + this.keyType + "[" + key + "] for [" + target + "]"));
                }
                this.cache.put(key, target.getNodeID());
            }
        }
        return result != null ? result : TargetResult.REFUSED_UNAVAILABLE_RESULT;
    }
}

