/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.PathElement;
import org.wildfly.extension.mod_cluster.CustomLoadMetricResourceDefinition;
import org.wildfly.extension.mod_cluster.LoadMetricResourceDefinition;
import org.wildfly.extension.mod_cluster.ProxyConfigurationResourceDefinition;

enum XMLElement {
    UNKNOWN((String)null),
    PROXY(ProxyConfigurationResourceDefinition.WILDCARD_PATH),
    SIMPLE_LOAD_PROVIDER("simple-load-provider"),
    DYNAMIC_LOAD_PROVIDER("dynamic-load-provider"),
    CUSTOM_LOAD_METRIC(CustomLoadMetricResourceDefinition.WILDCARD_PATH),
    LOAD_METRIC(LoadMetricResourceDefinition.WILDCARD_PATH),
    PROPERTY("property"),
    SSL("ssl");

    private final String name;
    private static final Map<String, XMLElement> MAP;

    private XMLElement(String name) {
        this.name = name;
    }

    private XMLElement(PathElement path) {
        this.name = path.getKey();
    }

    public String getLocalName() {
        return this.name;
    }

    public static XMLElement forName(String localName) {
        XMLElement element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, XMLElement> map = new HashMap<String, XMLElement>();
        for (XMLElement element : XMLElement.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

