/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.creation;

import jakarta.annotation.PostConstruct;
import org.jberet.creation.AbstractArtifactFactory;
import org.jberet.creation.ArtifactCreationContext;
import org.jberet.spi.ArtifactFactory;

public final class ArtifactFactoryWrapper
extends AbstractArtifactFactory {
    private final ArtifactFactory factory;

    public ArtifactFactoryWrapper(ArtifactFactory factory) {
        this.factory = factory;
    }

    @Override
    public void destroy(Object instance) {
        this.factory.destroy(instance);
    }

    @Override
    public Class<?> getArtifactClass(String ref, ClassLoader classLoader) {
        Class<?> cls = this.factory.getArtifactClass(ref, classLoader);
        if (cls == null) {
            cls = ArtifactFactoryWrapper.getClassFromBatchXmlOrClassLoader(ref, classLoader);
        }
        return cls;
    }

    @Override
    public Object create(String ref, Class<?> cls, ClassLoader classLoader) throws Exception {
        Class<?> c;
        Object obj = this.factory.create(ref, cls, classLoader);
        if (obj == null && (c = ArtifactFactoryWrapper.getClassFromBatchXmlOrClassLoader(ref, classLoader)) != null) {
            obj = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ArtifactCreationContext acc = ArtifactCreationContext.getCurrentArtifactCreationContext();
            this.doInjection(obj, c, classLoader, acc.jobContext, acc.stepContext, acc.properties);
            this.invokeAnnotatedLifecycleMethod(obj, c, PostConstruct.class);
        }
        return obj;
    }
}

