/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.predicate;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.FilterJdbcParameter;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class FilterPredicate
implements Predicate {
    private Junction fragments = new Junction();
    private List<FilterJdbcParameter> parameters;

    public void applyFragment(FilterFragmentPredicate predicate) {
        this.fragments.add(predicate);
    }

    public void applyFragment(String sqlFragment) {
        this.fragments.add(new FilterFragmentPredicate(sqlFragment));
    }

    public void applyParameter(FilterJdbcParameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<FilterJdbcParameter>();
        }
        this.parameters.add(parameter);
    }

    public Junction getFragments() {
        return this.fragments;
    }

    public List<FilterJdbcParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isEmpty() {
        return this.fragments.isEmpty();
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitFilterPredicate(this);
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return null;
    }

    public static class FilterFragmentPredicate
    implements Predicate {
        private final String sqlFragment;

        public FilterFragmentPredicate(String sqlFragment) {
            this.sqlFragment = sqlFragment;
        }

        public String getSqlFragment() {
            return this.sqlFragment;
        }

        @Override
        public void accept(SqlAstWalker sqlTreeWalker) {
            sqlTreeWalker.visitFilterFragmentPredicate(this);
        }

        @Override
        public JdbcMappingContainer getExpressionType() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }
}

