/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.sql.internal.SqlAstQueryPartProcessingStateImpl;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;

public class LoaderSqlAstCreationState
implements SqlAstProcessingState,
SqlAstCreationState,
DomainResultCreationState,
QueryOptions {
    private final SqlAliasBaseManager sqlAliasBaseManager;
    private final boolean forceIdentifierSelection;
    private final SqlAstCreationContext sf;
    private final SqlAstQueryPartProcessingStateImpl processingState;
    private final FromClauseAccess fromClauseAccess;
    private final LockOptions lockOptions;
    private final FetchProcessor fetchProcessor;
    private boolean resolvingCircularFetch;
    private ForeignKeyDescriptor.Nature currentlyResolvingForeignKeySide;
    private Set<AssociationKey> visitedAssociationKeys = new HashSet<AssociationKey>();

    public LoaderSqlAstCreationState(QueryPart queryPart, SqlAliasBaseManager sqlAliasBaseManager, FromClauseAccess fromClauseAccess, LockOptions lockOptions, FetchProcessor fetchProcessor, boolean forceIdentifierSelection, SqlAstCreationContext sf) {
        this.sqlAliasBaseManager = sqlAliasBaseManager;
        this.fromClauseAccess = fromClauseAccess;
        this.lockOptions = lockOptions;
        this.fetchProcessor = fetchProcessor;
        this.forceIdentifierSelection = forceIdentifierSelection;
        this.sf = sf;
        this.processingState = new SqlAstQueryPartProcessingStateImpl(queryPart, this, this, () -> Clause.IRRELEVANT, true);
    }

    @Override
    public SqlAstCreationContext getCreationContext() {
        return this.sf;
    }

    @Override
    public SqlAstProcessingState getCurrentProcessingState() {
        return this;
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this.processingState;
    }

    @Override
    public FromClauseAccess getFromClauseAccess() {
        return this.fromClauseAccess;
    }

    @Override
    public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public void registerLockMode(String identificationVariable, LockMode explicitLockMode) {
        throw new UnsupportedOperationException("Registering lock modes should only be done for result set mappings!");
    }

    @Override
    public List<Fetch> visitFetches(FetchParent fetchParent) {
        return this.fetchProcessor.visitFetches(fetchParent, this.processingState.getInflightQueryPart().getFirstQuerySpec(), this);
    }

    @Override
    public boolean isResolvingCircularFetch() {
        return this.resolvingCircularFetch;
    }

    @Override
    public void setResolvingCircularFetch(boolean resolvingCircularFetch) {
        this.resolvingCircularFetch = resolvingCircularFetch;
    }

    @Override
    public ForeignKeyDescriptor.Nature getCurrentlyResolvingForeignKeyPart() {
        return this.currentlyResolvingForeignKeySide;
    }

    @Override
    public void setCurrentlyResolvingForeignKeyPart(ForeignKeyDescriptor.Nature currentlyResolvingForeignKeySide) {
        this.currentlyResolvingForeignKeySide = currentlyResolvingForeignKeySide;
    }

    @Override
    public boolean forceIdentifierSelection() {
        return this.forceIdentifierSelection;
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this;
    }

    @Override
    public boolean registerVisitedAssociationKey(AssociationKey associationKey) {
        return this.visitedAssociationKeys.add(associationKey);
    }

    @Override
    public void removeVisitedAssociationKey(AssociationKey associationKey) {
        this.visitedAssociationKeys.remove(associationKey);
    }

    @Override
    public boolean isAssociationKeyVisited(AssociationKey associationKey) {
        return this.visitedAssociationKeys.contains(associationKey);
    }

    @Override
    public boolean isRegisteringVisitedAssociationKeys() {
        return true;
    }

    @Override
    public ModelPart resolveModelPart(NavigablePath navigablePath) {
        return this.fromClauseAccess.findTableGroup(navigablePath).getModelPart();
    }

    @Override
    public SqlAstProcessingState getParentState() {
        return null;
    }

    @Override
    public Integer getTimeout() {
        return null;
    }

    @Override
    public FlushMode getFlushMode() {
        return null;
    }

    @Override
    public Boolean isReadOnly() {
        return null;
    }

    @Override
    public AppliedGraph getAppliedGraph() {
        return null;
    }

    public TupleTransformer getTupleTransformer() {
        return null;
    }

    public ResultListTransformer getResultListTransformer() {
        return null;
    }

    @Override
    public Boolean isResultCachingEnabled() {
        return false;
    }

    @Override
    public CacheRetrieveMode getCacheRetrieveMode() {
        return CacheRetrieveMode.BYPASS;
    }

    @Override
    public CacheStoreMode getCacheStoreMode() {
        return CacheStoreMode.BYPASS;
    }

    @Override
    public String getResultCacheRegionName() {
        return null;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public List<String> getDatabaseHints() {
        return null;
    }

    @Override
    public Integer getFetchSize() {
        return null;
    }

    @Override
    public Limit getLimit() {
        return null;
    }

    public static interface FetchProcessor {
        public List<Fetch> visitFetches(FetchParent var1, QuerySpec var2, LoaderSqlAstCreationState var3);
    }
}

