/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.AbstractTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnknownTableReferenceException;

public abstract class DerivedTableReference
extends AbstractTableReference {
    private final List<String> columnNames;
    private final boolean lateral;

    public DerivedTableReference(String identificationVariable, List<String> columnNames, boolean lateral, SessionFactoryImplementor sessionFactory) {
        super(identificationVariable, false);
        this.columnNames = columnNames;
        this.lateral = lateral;
    }

    @Override
    public String getTableId() {
        return null;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public boolean isLateral() {
        return this.lateral;
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
        throw new UnknownTableReferenceException(tableExpression, "TableReferences cannot be resolved relative to DerivedTableReferences - `" + tableExpression + "` : " + navigablePath);
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        return null;
    }
}

