/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.session.spi;

import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;

public final class DetachedBackendSessionContext {
    private final BackendMappingContext mappingContext;
    private final String tenantIdentifier;

    public static DetachedBackendSessionContext of(BackendSessionContext sessionContext) {
        return new DetachedBackendSessionContext(sessionContext.mappingContext(), sessionContext.tenantIdentifier());
    }

    public static DetachedBackendSessionContext of(BackendMappingContext mappingContext, String tenantIdentifier) {
        return new DetachedBackendSessionContext(mappingContext, tenantIdentifier);
    }

    private DetachedBackendSessionContext(BackendMappingContext mappingContext, String tenantIdentifier) {
        this.mappingContext = mappingContext;
        this.tenantIdentifier = tenantIdentifier;
    }

    public BackendMappingContext mappingContext() {
        return this.mappingContext;
    }

    public String tenantIdentifier() {
        return this.tenantIdentifier;
    }
}

