/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.transaction;

import java.util.Map;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionDetail;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;

public class JMSTransactionDetail
extends TransactionDetail {
    public JMSTransactionDetail(Xid xid, Transaction tx, Long creation) {
        super(xid, tx, creation);
    }

    public String decodeMessageType(Message msg) {
        if (!(msg instanceof ICoreMessage)) {
            return "N/A";
        }
        byte type = ((ICoreMessage)msg).getType();
        switch (type) {
            case 0: {
                return "Default";
            }
            case 2: {
                return "ObjectMessage";
            }
            case 3: {
                return "TextMessage";
            }
            case 4: {
                return "ByteMessage";
            }
            case 5: {
                return "MapMessage";
            }
            case 6: {
                return "StreamMessage";
            }
        }
        return "(Unknown Type)";
    }

    public Map<String, Object> decodeMessageProperties(Message msg) {
        try {
            return ActiveMQMessage.coreMaptoJMSMap((Map)msg.toMap());
        }
        catch (Throwable t) {
            return null;
        }
    }
}

