/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.auth;

import java.io.IOException;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommandActivator;
import org.jboss.as.cli.impl.aesh.cmd.security.auth.AbstractMgmtEnableAuthenticationCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.auth.OptionActivators;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactorySpec;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.model.DefaultResourceNames;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ManagementInterfaces;
import org.jboss.as.cli.operation.OperationFormatException;

@CommandDefinition(name="enable-sasl-management", description="", activator=SecurityCommandActivator.class)
public class ManagementEnableSASLCommand
extends AbstractMgmtEnableAuthenticationCommand {
    @Option(name="management-interface", activator=OptionActivators.DependsOnMechanism.class, completer=SecurityCommand.OptionCompleters.ManagementInterfaceCompleter.class)
    String managementInterface;

    public ManagementEnableSASLCommand() {
        super(AuthFactorySpec.SASL);
    }

    @Override
    protected void secure(CommandContext ctx, AuthSecurityBuilder builder) throws Exception {
        ManagementInterfaces.enableSASL(this.managementInterface, builder, ctx);
    }

    @Override
    protected String getEnabledFactory(CommandContext ctx) throws IOException, OperationFormatException {
        return ManagementInterfaces.getManagementInterfaceSaslFactoryName(this.managementInterface, ctx);
    }

    @Override
    protected String getOOTBFactory(CommandContext ctx) throws Exception {
        return ElytronUtil.OOTB_MANAGEMENT_SASL_FACTORY;
    }

    @Override
    protected String getSecuredEndpoint(CommandContext ctx) {
        if (this.managementInterface == null) {
            this.managementInterface = DefaultResourceNames.getDefaultManagementInterfaceName(ctx);
        }
        return "management " + this.managementInterface;
    }
}

