/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.Collection;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.modules.Module;

public abstract class AbstractMergingProcessor<T extends EJBComponentDescription>
implements DeploymentUnitProcessor {
    private final Class<T> typeParam;

    public AbstractMergingProcessor(Class<T> typeParam) {
        this.typeParam = typeParam;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        Collection componentConfigurations = eeModuleDescription.getComponentDescriptions();
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        if (componentConfigurations == null || componentConfigurations.isEmpty()) {
            return;
        }
        for (ComponentDescription componentConfiguration : componentConfigurations) {
            if (!this.typeParam.isAssignableFrom(componentConfiguration.getClass())) continue;
            try {
                this.processComponentConfig(deploymentUnit, applicationClasses, module, deploymentReflectionIndex, (EJBComponentDescription)componentConfiguration);
            }
            catch (Exception e) {
                throw EjbLogger.ROOT_LOGGER.failToMergeData(componentConfiguration.getComponentName(), e);
            }
        }
    }

    private void processComponentConfig(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, Module module, DeploymentReflectionIndex deploymentReflectionIndex, T description) throws DeploymentUnitProcessingException {
        Class componentClass;
        try {
            componentClass = module.getClassLoader().loadClass(((EJBComponentDescription)((Object)description)).getEJBClassName());
        }
        catch (ClassNotFoundException e) {
            throw EjbLogger.ROOT_LOGGER.failToLoadEjbClass(((EJBComponentDescription)((Object)description)).getEJBClassName(), e);
        }
        if (!MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)deploymentUnit)) {
            this.handleAnnotations(deploymentUnit, applicationClasses, deploymentReflectionIndex, componentClass, description);
        }
        this.handleDeploymentDescriptor(deploymentUnit, deploymentReflectionIndex, componentClass, description);
    }

    protected abstract void handleAnnotations(DeploymentUnit var1, EEApplicationClasses var2, DeploymentReflectionIndex var3, Class<?> var4, T var5) throws DeploymentUnitProcessingException;

    protected abstract void handleDeploymentDescriptor(DeploymentUnit var1, DeploymentReflectionIndex var2, Class<?> var3, T var4) throws DeploymentUnitProcessingException;

    protected MethodInterfaceType getMethodIntf(MethodInterfaceType viewType, MethodInterfaceType defaultMethodIntf) {
        return viewType == null ? defaultMethodIntf : viewType;
    }

    protected String[] getMethodParams(MethodParametersMetaData methodParametersMetaData) {
        if (methodParametersMetaData == null) {
            return null;
        }
        return (String[])methodParametersMetaData.toArray((Object[])new String[methodParametersMetaData.size()]);
    }
}

