/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.client;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.jboss.as.clustering.infinispan.client.RemoteCacheManager;
import org.jboss.as.clustering.infinispan.dataconversion.MediaTypeFactory;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.infinispan.client.NearCacheFactory;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.marshalling.ByteBufferMarshallerFactory;
import org.wildfly.clustering.infinispan.marshalling.UserMarshaller;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ManagedRemoteCacheContainer
implements RemoteCacheContainer {
    private final RemoteCacheManager manager;
    private final Function<ClassLoader, ByteBufferMarshaller> marshallerFactory;

    public ManagedRemoteCacheContainer(RemoteCacheManager manager, ModuleLoader loader) {
        this.manager = manager;
        this.marshallerFactory = new ByteBufferMarshallerFactory(manager.getConfiguration().marshaller().mediaType(), loader);
    }

    public String getName() {
        return this.manager.getName();
    }

    public RemoteCacheManagerAdmin administration() {
        return this.manager.administration();
    }

    public <K, V> RemoteCacheContainer.NearCacheRegistration registerNearCacheFactory(String cacheName, NearCacheFactory<K, V> factory) {
        return this.manager.registerNearCacheFactory(cacheName, factory);
    }

    public <K, V> RemoteCache<K, V> getCache() {
        return this.getCache("");
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName) {
        boolean overrideValueMarshaller;
        RemoteCache cache = this.manager.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        Marshaller defaultMarshaller = this.manager.getMarshaller();
        DataFormat.Builder builder = DataFormat.builder().from(cache.getDataFormat()).keyType(defaultMarshaller.mediaType()).valueType(defaultMarshaller.mediaType());
        ClassLoader loader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        Map.Entry<MediaType, MediaType> types = MediaTypeFactory.INSTANCE.apply(loader);
        boolean overrideKeyMarshaller = !types.getKey().equals((Object)MediaType.APPLICATION_OBJECT);
        boolean bl = overrideValueMarshaller = !types.getValue().equals((Object)MediaType.APPLICATION_OBJECT);
        if (overrideKeyMarshaller || overrideValueMarshaller) {
            UserMarshaller marshaller = new UserMarshaller(defaultMarshaller.mediaType(), this.marshallerFactory.apply(loader));
            if (overrideKeyMarshaller) {
                builder.keyType(marshaller.mediaType());
                builder.keyMarshaller((Marshaller)marshaller);
            }
            if (overrideValueMarshaller) {
                builder.valueType(marshaller.mediaType());
                builder.valueMarshaller((Marshaller)marshaller);
            }
        }
        return cache.withDataFormat(builder.build());
    }

    public Configuration getConfiguration() {
        return this.manager.getConfiguration();
    }

    public boolean isStarted() {
        return this.manager.isStarted();
    }

    public boolean switchToCluster(String clusterName) {
        return this.manager.switchToCluster(clusterName);
    }

    public boolean switchToDefaultCluster() {
        return this.manager.switchToDefaultCluster();
    }

    public Marshaller getMarshaller() {
        return this.manager.getMarshaller();
    }

    public Set<String> getCacheNames() {
        return this.manager.getCacheNames();
    }

    public void start() {
    }

    public void stop() {
    }

    public String[] getServers() {
        return this.manager.getServers();
    }

    public int getActiveConnectionCount() {
        return this.manager.getActiveConnectionCount();
    }

    public int getConnectionCount() {
        return this.manager.getConnectionCount();
    }

    public int getIdleConnectionCount() {
        return this.manager.getIdleConnectionCount();
    }

    public long getRetries() {
        return this.manager.getRetries();
    }

    public boolean isTransactional(String cacheName) {
        return this.manager.isTransactional(cacheName);
    }
}

