/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.net.URI;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQPReplicaTest
extends AmqpClientTestSupport {
    protected static final int AMQP_PORT_2 = 5673;
    protected static final int AMQP_PORT_3 = 5674;
    public static final int TIME_BEFORE_RESTART = 1000;
    ActiveMQServer server_2;

    @Before
    public void startLogging() {
        AssertionLoggerHandler.startCapture();
    }

    @After
    public void stopLogging() {
        try {
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ222214"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672, false);
    }

    @Test
    public void testReplicaCatchupOnQueueCreates() throws Exception {
        this.server.setIdentity("Server1");
        this.server.stop();
        this.server_2 = this.createServer(5673, false);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo("sometest").setAutoCreated(false));
        this.server_2.createQueue(new QueueConfiguration("sometest").setDurable(Boolean.valueOf(true)));
        Wait.assertTrue(() -> this.server_2.locateQueue("sometest") != null);
        this.server_2.stop();
        this.server.start();
        Assert.assertTrue((this.server.locateQueue("sometest") == null ? 1 : 0) != 0);
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        this.server_2.start();
        Wait.assertTrue(() -> this.server.locateQueue("sometest") != null);
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testDeleteQueueWithRemoveFalse() throws Exception {
        this.server.setIdentity("Server1");
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setQueueRemoval(false));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        SimpleString queueName = RandomUtil.randomSimpleString();
        this.server_2.addAddressInfo(new AddressInfo(queueName).setAutoCreated(false));
        this.server_2.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(true)));
        Wait.assertTrue(() -> this.server_2.locateQueue(queueName) != null);
        Wait.assertTrue(() -> this.server.locateQueue(queueName) != null);
        this.server_2.destroyQueue(queueName);
        Wait.assertTrue(() -> this.server_2.locateQueue(queueName) == null);
        Thread.sleep(100L);
        Assert.assertTrue((String)"Queue was removed when it was configured to not remove it", (this.server.locateQueue(queueName) != null ? 1 : 0) != 0);
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testSendCreateQueue() throws Exception {
        this.doSendCreateQueueTestImpl(true);
    }

    @Test
    public void testDoNotSendCreateQueue() throws Exception {
        this.doSendCreateQueueTestImpl(false);
    }

    private void doSendCreateQueueTestImpl(boolean sendCreate) throws Exception {
        this.server.start();
        SimpleString ADDRESS_NAME = SimpleString.toSimpleString((String)"address");
        this.server_2 = this.createServer(5673, false);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        AMQPMirrorBrokerConnectionElement mirror = new AMQPMirrorBrokerConnectionElement();
        if (sendCreate) {
            mirror.setQueueCreation(true);
            mirror.setQueueRemoval(false);
        } else {
            mirror.setQueueCreation(false);
        }
        amqpConnection.addElement((AMQPBrokerConnectionElement)mirror);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        this.server_2.addAddressInfo(new AddressInfo(ADDRESS_NAME).addRoutingType(RoutingType.ANYCAST));
        this.server_2.createQueue(new QueueConfiguration(ADDRESS_NAME).setDurable(Boolean.valueOf(true)).setAddress(ADDRESS_NAME));
        if (sendCreate) {
            Wait.assertTrue(() -> this.server.locateQueue(ADDRESS_NAME) != null);
            Wait.assertTrue(() -> this.server.getAddressInfo(ADDRESS_NAME) != null);
        } else {
            Thread.sleep(250L);
            Assert.assertTrue((this.server.locateQueue(ADDRESS_NAME) == null ? 1 : 0) != 0);
            Assert.assertTrue((this.server.getAddressInfo(ADDRESS_NAME) == null ? 1 : 0) != 0);
        }
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testReplicaCatchupOnQueueCreatesAndDeletes() throws Exception {
        this.server.start();
        this.server.setIdentity("Server1");
        this.server.addAddressInfo(new AddressInfo("sometest").setAutoCreated(false).addRoutingType(RoutingType.MULTICAST));
        this.server.createQueue(new QueueConfiguration("ToBeGone").setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.MULTICAST));
        this.server.stop();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo("sometest").setAutoCreated(false).addRoutingType(RoutingType.MULTICAST));
        this.server_2.createQueue(new QueueConfiguration("sometest").setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.MULTICAST));
        Wait.assertTrue(() -> this.server_2.locateQueue("sometest") != null);
        this.server_2.stop();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        Assert.assertTrue((this.server.locateQueue("sometest") == null ? 1 : 0) != 0);
        Assert.assertTrue((this.server.locateQueue("ToBeGone") != null ? 1 : 0) != 0);
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        this.server_2.start();
        Wait.assertTrue(() -> this.server.locateQueue("sometest") != null);
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testReplicaWithDurable() throws Exception {
        this.server.start();
        this.server.setIdentity("Server1");
        this.server.addAddressInfo(new AddressInfo("sometest").setAutoCreated(false).addRoutingType(RoutingType.MULTICAST));
        this.server.stop();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo("sometest").setAutoCreated(false).addRoutingType(RoutingType.MULTICAST));
        this.server_2.createQueue(new QueueConfiguration("sometest").setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.MULTICAST));
        Wait.assertTrue(() -> this.server_2.locateQueue("sometest") != null);
        this.server_2.stop();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        Assert.assertTrue((this.server.locateQueue("sometest") == null ? 1 : 0) != 0);
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        this.server_2.start();
        Wait.assertTrue(() -> this.server.locateQueue("sometest") != null);
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testReplicaLargeMessages() throws Exception {
        this.replicaTest(true, true, false, false, false, false, false);
    }

    @Test
    public void testReplicaLargeMessagesPagingEverywhere() throws Exception {
        this.replicaTest(true, true, true, true, false, false, false);
    }

    @Test
    public void testReplica() throws Exception {
        this.replicaTest(false, true, false, false, false, false, false);
    }

    @Test
    public void testReplicaRestartBrokerConnection() throws Exception {
        this.replicaTest(false, true, false, false, false, false, true);
    }

    @Test
    public void testReplicaRestart() throws Exception {
        this.replicaTest(false, true, false, false, false, true, false);
    }

    @Test
    public void testReplicaDeferredStart() throws Exception {
        this.replicaTest(false, true, false, false, true, false, false);
    }

    @Test
    public void testReplicaCopyOnly() throws Exception {
        this.replicaTest(false, false, false, false, false, false, false);
    }

    @Test
    public void testReplicaPagedTarget() throws Exception {
        this.replicaTest(false, true, true, false, false, false, false);
    }

    @Test
    public void testReplicaPagingEverywhere() throws Exception {
        this.replicaTest(false, true, true, true, false, false, false);
    }

    private String getText(boolean large, int i) {
        if (!large) {
            return "Text " + i;
        }
        StringBuffer buffer = new StringBuffer();
        while (buffer.length() < 112640) {
            buffer.append("Text " + i + " ");
        }
        return buffer.toString();
    }

    @Test
    public void testLargeMessagesWithDeliveryAnnotations() throws Exception {
        int i;
        this.server.setIdentity("targetServer");
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        AMQPMirrorBrokerConnectionElement replica = new AMQPMirrorBrokerConnectionElement().setMessageAcknowledgements(true);
        amqpConnection.addElement((AMQPBrokerConnectionElement)replica);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        int NUMBER_OF_MESSAGES = 20;
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false));
        this.server_2.createQueue(new QueueConfiguration(this.getQueueName()).setRoutingType(RoutingType.ANYCAST).setAddress(this.getQueueName()).setAutoCreated(Boolean.valueOf(false)));
        Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ222214"}));
        Queue queueView = this.locateQueue(this.server_2, this.getQueueName());
        Queue queueViewReplica = this.locateQueue(this.server_2, this.getQueueName());
        AmqpClient client = new AmqpClient(new URI("tcp://localhost:5673"), null, null);
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setDeliveryAnnotation("gone", (Object)"test");
            message.setText(this.getText(true, i));
            sender.send(message);
        }
        sender.close();
        connection.close();
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueView).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueViewReplica).getMessageCount());
        client = new AmqpClient(new URI("tcp://localhost:5672"), null, null);
        connection = this.addConnection(client.connect());
        session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(NUMBER_OF_MESSAGES + 1);
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            AMQPReplicaTest.assertNotNull((Object)received);
            Assert.assertEquals((Object)this.getText(true, i), (Object)received.getText());
            Assert.assertNull((Object)received.getDeliveryAnnotation("gone"));
        }
        Assert.assertNull((Object)receiver.receiveNoWait());
        connection.close();
    }

    @Test
    public void testNoAddressWithAnnotations() throws Exception {
        int i;
        this.server.setIdentity("targetServer");
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        AMQPMirrorBrokerConnectionElement replica = new AMQPMirrorBrokerConnectionElement().setMessageAcknowledgements(true);
        amqpConnection.addElement((AMQPBrokerConnectionElement)replica);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        int NUMBER_OF_MESSAGES = 20;
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false));
        this.server_2.createQueue(new QueueConfiguration(this.getQueueName()).setRoutingType(RoutingType.ANYCAST).setAddress(this.getQueueName()).setAutoCreated(Boolean.valueOf(false)));
        Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ222214"}));
        AmqpClient client = new AmqpClient(new URI("tcp://localhost:5673"), null, null);
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setDeliveryAnnotation("gone", (Object)"test");
            message.setText(this.getText(false, i));
            sender.send(message);
        }
        sender.close();
        connection.close();
        client = new AmqpClient(new URI("tcp://localhost:5672"), null, null);
        connection = this.addConnection(client.connect());
        session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(NUMBER_OF_MESSAGES + 1);
        for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            AMQPReplicaTest.assertNotNull((Object)received);
            Assert.assertEquals((Object)this.getText(false, i), (Object)received.getText());
            Assert.assertNull((Object)received.getDeliveryAnnotation("gone"));
        }
        Assert.assertNull((Object)receiver.receiveNoWait());
        connection.close();
    }

    @Test
    public void testRouteSurviving() throws Exception {
        this.testRouteSurvivor(false);
    }

    @Test
    public void testRouteSurvivingStop() throws Exception {
        this.testRouteSurvivor(true);
    }

    private void testRouteSurvivor(boolean server1Stopped) throws Exception {
        if (!server1Stopped) {
            this.server.start();
        }
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        this.server_2.getConfiguration().setName("thisone");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("OtherSide", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        AMQPMirrorBrokerConnectionElement replica = new AMQPMirrorBrokerConnectionElement().setDurable(true);
        amqpConnection.addElement((AMQPBrokerConnectionElement)replica);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false));
        this.server_2.createQueue(new QueueConfiguration(this.getQueueName()).setRoutingType(RoutingType.ANYCAST).setAddress(this.getQueueName()).setAutoCreated(Boolean.valueOf(false)));
        int NUMBER_OF_MESSAGES = 200;
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
        producer.setDeliveryMode(2);
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            producer.send((Message)session.createTextMessage("i=" + i));
        }
        connection.close();
        if (!server1Stopped) {
            Wait.assertTrue(() -> this.server.locateQueue(this.getQueueName()) != null);
            Queue queueServer1 = this.server.locateQueue(this.getQueueName());
            Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueServer1).getMessageCount());
        }
        Wait.assertTrue(() -> this.server_2.locateQueue(this.getQueueName()) != null);
        Queue queueServer2 = this.server_2.locateQueue(this.getQueueName());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueServer2).getMessageCount());
        if (!server1Stopped) {
            this.server.stop();
        }
        this.server_2.stop();
        this.server.start();
        this.server_2.start();
        Wait.assertTrue(() -> this.server.locateQueue(this.getQueueName()) != null);
        Wait.assertTrue(() -> this.server_2.locateQueue(this.getQueueName()) != null);
        Queue queueServer1 = this.server.locateQueue(this.getQueueName());
        Queue queueServer22 = this.server_2.locateQueue(this.getQueueName());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueServer1).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueServer22).getMessageCount());
    }

    private void replicaTest(boolean largeMessage, boolean acks, boolean pagingTarget, boolean pagingSource, boolean deferredStart, boolean restartAndDisconnect, boolean restartBrokerConnection) throws Exception {
        Queue queueOnServer1;
        String brokerConnectionName = "brokerConnectionName:" + UUIDGenerator.getInstance().generateStringUUID();
        this.server.setIdentity("targetServer");
        if (deferredStart) {
            this.server.stop();
        } else {
            this.server.start();
        }
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("server_2");
        this.server_2.getConfiguration().setName("thisone");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(brokerConnectionName, "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        AMQPMirrorBrokerConnectionElement replica = new AMQPMirrorBrokerConnectionElement().setMessageAcknowledgements(acks);
        amqpConnection.addElement((AMQPBrokerConnectionElement)replica);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        int NUMBER_OF_MESSAGES = 200;
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false));
        this.server_2.createQueue(new QueueConfiguration(this.getQueueName()).setRoutingType(RoutingType.ANYCAST).setAddress(this.getQueueName()).setAutoCreated(Boolean.valueOf(false)));
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
        producer.setDeliveryMode(1);
        if (!deferredStart) {
            Queue queueOnServer12 = this.locateQueue(this.server, this.getQueueName());
            if (pagingTarget) {
                queueOnServer12.getPagingStore().startPaging();
            }
        }
        if (pagingSource) {
            Queue queueOnServer2 = this.server_2.locateQueue(this.getQueueName());
            queueOnServer2.getPagingStore().startPaging();
        }
        Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ222214"}));
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            TextMessage message = session.createTextMessage(this.getText(largeMessage, i));
            message.setIntProperty("i", i);
            producer.send((Message)message);
        }
        Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ222214"}));
        if (deferredStart) {
            Thread.sleep(1000L);
            this.server.start();
            Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
            queueOnServer1 = this.locateQueue(this.server, this.getQueueName());
            if (pagingTarget) {
                queueOnServer1.getPagingStore().startPaging();
            }
        } else {
            queueOnServer1 = this.locateQueue(this.server, this.getQueueName());
        }
        Queue snfreplica = this.server_2.locateQueue(replica.getMirrorSNF());
        Assert.assertNotNull((Object)snfreplica);
        Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer1).getMessageCount(), (long)2000L);
        Queue queueOnServer2 = this.locateQueue(this.server_2, this.getQueueName());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer1).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer2).getMessageCount());
        if (restartBrokerConnection) {
            this.server_2.stopBrokerConnection(brokerConnectionName);
            Thread.sleep(1000L);
            this.server_2.startBrokerConnection(brokerConnectionName);
        }
        Assert.assertSame((Object)snfreplica, (Object)this.server_2.locateQueue(replica.getMirrorSNF()));
        if (pagingTarget) {
            AMQPReplicaTest.assertTrue((boolean)queueOnServer1.getPagingStore().isPaging());
        }
        if (acks) {
            this.consumeMessages(largeMessage, 0, NUMBER_OF_MESSAGES / 2 - 1, 5673, false);
            Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
            Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2), () -> ((Queue)queueOnServer1).getMessageCount());
            this.consumeMessages(largeMessage, NUMBER_OF_MESSAGES / 2, NUMBER_OF_MESSAGES - 1, 5672, true);
            Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
            this.consumeMessages(largeMessage, NUMBER_OF_MESSAGES / 2, NUMBER_OF_MESSAGES - 1, 5673, false);
            Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
            if (largeMessage) {
                this.validateNoFilesOnLargeDir(this.server.getConfiguration().getLargeMessagesDirectory(), 0);
            }
        } else {
            this.consumeMessages(largeMessage, 0, NUMBER_OF_MESSAGES - 1, 5673, true);
            Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
            this.consumeMessages(largeMessage, 0, NUMBER_OF_MESSAGES - 1, 5672, true);
            Wait.assertEquals((long)0L, () -> ((Queue)snfreplica).getMessageCount());
            if (largeMessage) {
                this.validateNoFilesOnLargeDir(this.server.getConfiguration().getLargeMessagesDirectory(), 0);
                this.validateNoFilesOnLargeDir(this.server_2.getConfiguration().getLargeMessagesDirectory(), 0);
            }
        }
        if (restartAndDisconnect) {
            this.server.stop();
            Thread.sleep(1000L);
            this.server.start();
            Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
            this.consumeMessages(largeMessage, 0, -1, 5673, true);
            this.consumeMessages(largeMessage, 0, -1, 5672, true);
            for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                TextMessage message = session.createTextMessage(this.getText(largeMessage, i));
                message.setIntProperty("i", i);
                producer.send((Message)message);
            }
            this.consumeMessages(largeMessage, 0, NUMBER_OF_MESSAGES - 1, 5672, true);
            this.consumeMessages(largeMessage, 0, NUMBER_OF_MESSAGES - 1, 5673, true);
        }
    }

    @Test
    public void testDualStandardRestartBrokerConnection() throws Exception {
        this.dualReplica(false, false, false, true);
    }

    @Test
    public void testDualStandard() throws Exception {
        this.dualReplica(false, false, false, false);
    }

    @Test
    public void testDualRegularPagedTargets() throws Exception {
        this.dualReplica(false, false, true, false);
    }

    @Test
    public void testDualRegularPagedEverything() throws Exception {
        this.dualReplica(false, true, true, false);
    }

    @Test
    public void testDualRegularLarge() throws Exception {
        this.dualReplica(true, false, false, false);
    }

    public Queue locateQueue(ActiveMQServer server, String queueName) throws Exception {
        Wait.waitFor(() -> server.locateQueue(queueName) != null);
        return server.locateQueue(queueName);
    }

    private void dualReplica(boolean largeMessage, boolean pagingSource, boolean pagingTarget, boolean restartBC) throws Exception {
        this.server.setIdentity("server_1");
        this.server.start();
        ActiveMQServer server_3 = this.createServer(5674, false);
        server_3.setIdentity("server_3");
        server_3.start();
        Wait.assertTrue(() -> ((ActiveMQServer)server_3).isStarted());
        ConnectionFactory factory_3 = CFUtil.createConnectionFactory("amqp", "tcp://localhost:5674");
        factory_3.createConnection().close();
        this.server_2 = this.createServer(5673, false);
        String brokerConnectionOne = "brokerConnection1:" + UUIDGenerator.getInstance().generateStringUUID();
        String brokerConnectionTwo = "brokerConnection2:" + UUIDGenerator.getInstance().generateStringUUID();
        AMQPBrokerConnectConfiguration amqpConnection1 = new AMQPBrokerConnectConfiguration(brokerConnectionOne, "tcp://localhost:5672");
        AMQPMirrorBrokerConnectionElement replica1 = new AMQPMirrorBrokerConnectionElement().setType(AMQPBrokerConnectionAddressType.MIRROR);
        amqpConnection1.addElement((AMQPBrokerConnectionElement)replica1);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection1);
        AMQPBrokerConnectConfiguration amqpConnection3 = new AMQPBrokerConnectConfiguration(brokerConnectionTwo, "tcp://localhost:5674");
        AMQPMirrorBrokerConnectionElement replica2 = new AMQPMirrorBrokerConnectionElement().setType(AMQPBrokerConnectionAddressType.MIRROR);
        amqpConnection3.addElement((AMQPBrokerConnectionElement)replica2);
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection3);
        int NUMBER_OF_MESSAGES = 200;
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
        producer.setDeliveryMode(2);
        Queue queue_server_2 = this.locateQueue(this.server_2, this.getQueueName());
        Queue queue_server_1 = this.locateQueue(this.server, this.getQueueName());
        Queue queue_server_3 = this.locateQueue(server_3, this.getQueueName());
        if (pagingSource) {
            queue_server_2.getPagingStore().startPaging();
        }
        if (pagingTarget) {
            queue_server_1.getPagingStore().startPaging();
            queue_server_3.getPagingStore().startPaging();
        }
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            TextMessage message = session.createTextMessage(this.getText(largeMessage, i));
            message.setIntProperty("i", i);
            producer.send((Message)message);
            if (i != NUMBER_OF_MESSAGES / 2 || !restartBC) continue;
            Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2 + 1), () -> ((Queue)queue_server_2).getMessageCount());
            Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2 + 1), () -> ((Queue)queue_server_3).getMessageCount());
            Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2 + 1), () -> ((Queue)queue_server_1).getMessageCount());
            this.server_2.stopBrokerConnection(brokerConnectionOne);
            this.server_2.stopBrokerConnection(brokerConnectionTwo);
            Thread.sleep(1000L);
            this.server_2.startBrokerConnection(brokerConnectionOne);
            this.server_2.startBrokerConnection(brokerConnectionTwo);
        }
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queue_server_2).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queue_server_3).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queue_server_1).getMessageCount());
        Queue replica1Queue = this.server_2.locateQueue(replica1.getMirrorSNF());
        Queue replica2Queue = this.server_2.locateQueue(replica2.getMirrorSNF());
        Wait.assertEquals((Long)0L, () -> ((PagingStore)replica2Queue.getPagingStore()).getAddressSize(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> ((PagingStore)replica1Queue.getPagingStore()).getAddressSize(), (long)1000L, (long)100L);
        if (pagingTarget) {
            Assert.assertTrue((boolean)queue_server_1.getPagingStore().isPaging());
            Assert.assertTrue((boolean)queue_server_3.getPagingStore().isPaging());
        }
        if (pagingSource) {
            Assert.assertTrue((boolean)queue_server_2.getPagingStore().isPaging());
        }
        this.consumeMessages(largeMessage, 0, NUMBER_OF_MESSAGES / 2 - 1, 5673, false);
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2), () -> ((Queue)queue_server_1).getMessageCount());
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2), () -> ((Queue)queue_server_2).getMessageCount());
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2), () -> ((Queue)queue_server_3).getMessageCount());
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES / 2), () -> ((Queue)queue_server_1).getMessageCount());
        this.consumeMessages(largeMessage, NUMBER_OF_MESSAGES / 2, NUMBER_OF_MESSAGES - 1, 5672, true);
        this.consumeMessages(largeMessage, NUMBER_OF_MESSAGES / 2, NUMBER_OF_MESSAGES - 1, 5674, true);
        this.consumeMessages(largeMessage, NUMBER_OF_MESSAGES / 2, NUMBER_OF_MESSAGES - 1, 5673, true);
        this.validateNoFilesOnLargeDir(this.server.getConfiguration().getLargeMessagesDirectory(), 0);
        this.validateNoFilesOnLargeDir(server_3.getConfiguration().getLargeMessagesDirectory(), 0);
        this.validateNoFilesOnLargeDir(this.server_2.getConfiguration().getLargeMessagesDirectory(), 0);
    }

    private void printMessages(String printInfo, Queue queue) {
        System.out.println("*******************************************************************************************************************************");
        System.out.println(printInfo);
        System.out.println();
        LinkedListIterator referencesIterator = queue.browserIterator();
        while (referencesIterator.hasNext()) {
            System.out.println("message " + ((MessageReference)referencesIterator.next()).getMessage());
        }
        referencesIterator.close();
        System.out.println("*******************************************************************************************************************************");
    }

    private void consumeMessages(boolean largeMessage, int START_ID, int LAST_ID, int port, boolean assertNull) throws JMSException {
        int i;
        ConnectionFactory cf = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:" + port);
        Connection conn = cf.createConnection();
        Session sess = conn.createSession(false, 1);
        conn.start();
        HashSet<Integer> idsReceived = new HashSet<Integer>();
        MessageConsumer consumer = sess.createConsumer((Destination)sess.createQueue(this.getQueueName()));
        for (i = START_ID; i <= LAST_ID; ++i) {
            Message message = consumer.receive(3000L);
            Assert.assertNotNull((Object)message);
            Integer id = message.getIntProperty("i");
            Assert.assertNotNull((Object)id);
            Assert.assertTrue((boolean)idsReceived.add(id));
        }
        if (assertNull) {
            Assert.assertNull((Object)consumer.receiveNoWait());
        }
        for (i = START_ID; i <= LAST_ID; ++i) {
            Assert.assertTrue((boolean)idsReceived.remove(i));
        }
        Assert.assertTrue((boolean)idsReceived.isEmpty());
        conn.close();
    }
}

