/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.paging;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageReaderTest;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.junit.Assert;
import org.junit.Test;

public class AmqpPageReaderTest
extends PageReaderTest {
    public MessageImpl createProtonMessage(String address) {
        AmqpMessage message = new AmqpMessage();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            builder.append('0');
        }
        String data = builder.toString();
        message.setText(data);
        message.setAddress(address);
        message.setDurable(true);
        MessageImpl protonMessage = (MessageImpl)message.getWrappedMessage();
        return protonMessage;
    }

    protected Message createMessage(SimpleString address, int msgId, byte[] content) {
        MessageImpl protonMessage = this.createProtonMessage(address.toString());
        AMQPStandardMessage amqpStandardMessage = AmqpTestSupport.encodeAndDecodeMessage(0, protonMessage, 2048);
        amqpStandardMessage.setMessageID((long)msgId);
        return amqpStandardMessage;
    }

    @Test
    public void testEncodeSize() throws Exception {
        Message message = this.createMessage(SimpleString.toSimpleString((String)"Test"), 1, new byte[10]);
        MessagePersister persister = (MessagePersister)message.getPersister();
        ActiveMQBuffer buffer = ActiveMQBuffers.dynamicBuffer((int)1024);
        persister.encode(buffer, message);
        Assert.assertEquals((long)persister.getEncodeSize(message), (long)buffer.writerIndex());
        buffer.readerIndex(1);
        Message messageRead = persister.decode(buffer, null, null);
    }
}

