/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OnewayTwoNodeClusterTest
extends ClusterTestBase {
    private static final Logger log = Logger.getLogger(OnewayTwoNodeClusterTest.class);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
    }

    private void setupCluster(MessageLoadBalancingType messageLoadBalancingType) {
        for (ActiveMQServer server : this.servers) {
            if (server == null) continue;
            server.getConfiguration().getClusterConfigurations().clear();
        }
        this.setupClusterConnection("cluster1", 0, 1, "queues", messageLoadBalancingType, 1, 0, 500L, this.isNetty(), true);
        this.setupClusterConnection("clusterX", 1, -1, "queues", messageLoadBalancingType, 1, 0, 500L, this.isNetty(), true);
    }

    protected boolean isNetty() {
        return false;
    }

    @Test
    public void testNeverStartTargetStartSourceThenStopSource() throws Exception {
        this.startServers(0);
        Thread.sleep(500L);
        this.stopServers(0);
    }

    @Test
    public void testStartTargetServerBeforeSourceServer() throws Exception {
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        String myFilter = "zebra";
        this.createQueue(1, "queues.testaddress", "queue0", myFilter, false);
        this.addConsumer(0, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.send(0, "queues.testaddress", 10, false, myFilter);
        this.verifyReceiveAll(10, 0);
        this.verifyNotReceive(0);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyNotReceive(0);
    }

    @Test
    public void testStartSourceServerBeforeTargetServer() throws Exception {
        this.startServers(0, 1);
        OnewayTwoNodeClusterTest.waitForTopology((ActiveMQServer)this.servers[0], (int)2);
        OnewayTwoNodeClusterTest.waitForTopology((ActiveMQServer)this.servers[1], (int)2);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        String myFilter = "bison";
        this.createQueue(1, "queues.testaddress", "queue0", myFilter, false);
        this.addConsumer(0, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.send(0, "queues.testaddress", 10, false, myFilter);
        this.verifyReceiveAll(10, 0);
        this.verifyNotReceive(0);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyNotReceive(0);
    }

    @Test
    public void testStopAndStartTarget() throws Exception {
        this.startServers(0, 1);
        OnewayTwoNodeClusterTest.waitForTopology((ActiveMQServer)this.servers[0], (int)2);
        OnewayTwoNodeClusterTest.waitForTopology((ActiveMQServer)this.servers[1], (int)2);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        String myFilter = "bison";
        this.createQueue(1, "queues.testaddress", "queue0", myFilter, true);
        this.addConsumer(0, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.send(0, "queues.testaddress", 10, false, myFilter);
        this.verifyReceiveAll(10, 0);
        this.verifyNotReceive(0);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyNotReceive(0);
        this.removeConsumer(0);
        this.closeSessionFactory(1);
        long start = System.currentTimeMillis();
        log.debug((Object)"stopping server 1");
        this.stopServers(1);
        OnewayTwoNodeClusterTest.waitForTopology((ActiveMQServer)this.servers[0], (int)1);
        log.debug((Object)("restarting server 1(" + this.servers[1].getIdentity() + ")"));
        this.startServers(1);
        OnewayTwoNodeClusterTest.waitForTopology((ActiveMQServer)this.servers[0], (int)2);
        log.debug((Object)("Server 1 id=" + this.servers[1].getNodeID()));
        long end = System.currentTimeMillis();
        Assert.assertTrue((String)"Took too long to restart", (end - start <= 5000L ? (byte)1 : 0) != 0);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.addConsumer(0, 1, "queue0", null);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.send(0, "queues.testaddress", 10, false, myFilter);
        this.verifyReceiveAll(10, 0);
        this.checkReceive(0);
        this.verifyNotReceive(0);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyNotReceive(0);
    }

    @Test
    public void testBasicLocalReceive() throws Exception {
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0);
        this.verifyNotReceive(0);
        this.addConsumer(1, 0, "queue0", null);
        this.verifyNotReceive(1);
        this.verifyClusterMetrics(0, "cluster1", 0L, 0L);
        this.verifyClusterMetrics(1, "clusterX", 0L, 0L);
        this.verifyBridgeMetrics(0, "cluster1", this.servers[1].getClusterManager().getNodeId(), 0L, 0L);
    }

    @Test
    public void testBasicRoundRobin() throws Exception {
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 0, 0, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobin(10, 0, 1);
        this.verifyNotReceive(0, 1);
        this.verifyClusterMetrics(0, "cluster1", 5L, 5L);
        this.verifyClusterMetrics(1, "clusterX", 0L, 0L);
        this.verifyBridgeMetrics(0, "cluster1", this.servers[1].getClusterManager().getNodeId(), 5L, 5L);
    }

    @Test
    public void testRoundRobinMultipleQueues() throws Exception {
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(1, "queues.testaddress", "queue2", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 0, "queue1", null);
        this.addConsumer(3, 1, "queue1", null);
        this.addConsumer(4, 0, "queue2", null);
        this.addConsumer(5, 1, "queue2", null);
        this.waitForBindings(0, "queues.testaddress", 3, 3, true);
        this.waitForBindings(0, "queues.testaddress", 3, 3, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobin(10, 0, 1);
        this.verifyReceiveRoundRobin(10, 2, 3);
        this.verifyReceiveRoundRobin(10, 4, 5);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5);
    }

    @Test
    public void testMultipleNonLoadBalancedQueues() throws Exception {
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(0, "queues.testaddress", "queue3", null, false);
        this.createQueue(0, "queues.testaddress", "queue4", null, false);
        this.createQueue(1, "queues.testaddress", "queue5", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(1, "queues.testaddress", "queue7", null, false);
        this.createQueue(1, "queues.testaddress", "queue8", null, false);
        this.createQueue(1, "queues.testaddress", "queue9", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 0, "queue2", null);
        this.addConsumer(3, 0, "queue3", null);
        this.addConsumer(4, 0, "queue4", null);
        this.addConsumer(5, 1, "queue5", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 1, "queue7", null);
        this.addConsumer(8, 1, "queue8", null);
        this.addConsumer(9, 1, "queue9", null);
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(0, "queues.testaddress", 5, 5, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    }

    @Test
    public void testMixtureLoadBalancedAndNonLoadBalancedQueues() throws Exception {
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(0, "queues.testaddress", "queue3", null, false);
        this.createQueue(0, "queues.testaddress", "queue4", null, false);
        this.createQueue(1, "queues.testaddress", "queue5", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(1, "queues.testaddress", "queue7", null, false);
        this.createQueue(1, "queues.testaddress", "queue8", null, false);
        this.createQueue(1, "queues.testaddress", "queue9", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(1, "queues.testaddress", "queue10", null, false);
        this.createQueue(0, "queues.testaddress", "queue11", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.createQueue(0, "queues.testaddress", "queue12", null, false);
        this.createQueue(1, "queues.testaddress", "queue12", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 0, "queue2", null);
        this.addConsumer(3, 0, "queue3", null);
        this.addConsumer(4, 0, "queue4", null);
        this.addConsumer(5, 1, "queue5", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 1, "queue7", null);
        this.addConsumer(8, 1, "queue8", null);
        this.addConsumer(9, 1, "queue9", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(11, 1, "queue10", null);
        this.addConsumer(12, 0, "queue11", null);
        this.addConsumer(13, 1, "queue11", null);
        this.addConsumer(14, 0, "queue12", null);
        this.addConsumer(15, 1, "queue12", null);
        this.waitForBindings(0, "queues.testaddress", 8, 8, true);
        this.waitForBindings(0, "queues.testaddress", 8, 8, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.verifyReceiveRoundRobin(10, 10, 11);
        this.verifyReceiveRoundRobin(10, 12, 13);
        this.verifyReceiveRoundRobin(10, 14, 15);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);
    }

    @Test
    public void testMixtureLoadBalancedAndNonLoadBalancedQueuesRemoveSomeQueuesAndConsumers() throws Exception {
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(0, "queues.testaddress", "queue3", null, false);
        this.createQueue(0, "queues.testaddress", "queue4", null, false);
        this.createQueue(1, "queues.testaddress", "queue5", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(1, "queues.testaddress", "queue7", null, false);
        this.createQueue(1, "queues.testaddress", "queue8", null, false);
        this.createQueue(1, "queues.testaddress", "queue9", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(1, "queues.testaddress", "queue10", null, false);
        this.createQueue(0, "queues.testaddress", "queue11", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.createQueue(0, "queues.testaddress", "queue12", null, false);
        this.createQueue(1, "queues.testaddress", "queue12", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 0, "queue2", null);
        this.addConsumer(3, 0, "queue3", null);
        this.addConsumer(4, 0, "queue4", null);
        this.addConsumer(5, 1, "queue5", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 1, "queue7", null);
        this.addConsumer(8, 1, "queue8", null);
        this.addConsumer(9, 1, "queue9", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(11, 1, "queue10", null);
        this.addConsumer(12, 0, "queue11", null);
        this.addConsumer(13, 1, "queue11", null);
        this.addConsumer(14, 0, "queue12", null);
        this.addConsumer(15, 1, "queue12", null);
        this.waitForBindings(0, "queues.testaddress", 8, 8, true);
        this.waitForBindings(0, "queues.testaddress", 8, 8, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.verifyReceiveRoundRobin(10, 10, 11);
        this.verifyReceiveRoundRobin(10, 12, 13);
        this.verifyReceiveRoundRobin(10, 14, 15);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);
        this.removeConsumer(10);
        this.removeConsumer(13);
        this.removeConsumer(14);
        this.deleteQueue(0, "queue10");
        this.deleteQueue(1, "queue11");
        this.deleteQueue(0, "queue12");
        this.waitForBindings(0, "queues.testaddress", 6, 6, true);
        this.waitForBindings(0, "queues.testaddress", 7, 7, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 15);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 15);
    }

    @Test
    public void testMixtureLoadBalancedAndNonLoadBalancedQueuesAddQueuesOnTargetBeforeStartSource() throws Exception {
        this.startServers(1);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(1, "queues.testaddress", "queue5", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(1, "queues.testaddress", "queue7", null, false);
        this.createQueue(1, "queues.testaddress", "queue8", null, false);
        this.createQueue(1, "queues.testaddress", "queue9", null, false);
        this.createQueue(1, "queues.testaddress", "queue10", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.createQueue(1, "queues.testaddress", "queue12", null, false);
        this.addConsumer(5, 1, "queue5", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 1, "queue7", null);
        this.addConsumer(8, 1, "queue8", null);
        this.addConsumer(9, 1, "queue9", null);
        this.addConsumer(11, 1, "queue10", null);
        this.addConsumer(13, 1, "queue11", null);
        this.addConsumer(15, 1, "queue12", null);
        this.startServers(0);
        this.waitForBindings(0, "queues.testaddress", 8, 8, false);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(0, "queues.testaddress", "queue3", null, false);
        this.createQueue(0, "queues.testaddress", "queue4", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(0, "queues.testaddress", "queue11", null, false);
        this.createQueue(0, "queues.testaddress", "queue12", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 0, "queue2", null);
        this.addConsumer(3, 0, "queue3", null);
        this.addConsumer(4, 0, "queue4", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(12, 0, "queue11", null);
        this.addConsumer(14, 0, "queue12", null);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.verifyReceiveRoundRobin(10, 11, 10);
        this.verifyReceiveRoundRobin(10, 13, 12);
        this.verifyReceiveRoundRobin(10, 15, 14);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);
    }

    @Test
    public void testMixtureLoadBalancedAndNonLoadBalancedQueuesAddQueuesOnSourceBeforeStartTarget() throws Exception {
        this.startServers(0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(0, "queues.testaddress", "queue3", null, false);
        this.createQueue(0, "queues.testaddress", "queue4", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(0, "queues.testaddress", "queue11", null, false);
        this.createQueue(0, "queues.testaddress", "queue12", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 0, "queue2", null);
        this.addConsumer(3, 0, "queue3", null);
        this.addConsumer(4, 0, "queue4", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(12, 0, "queue11", null);
        this.addConsumer(14, 0, "queue12", null);
        this.startServers(1);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(1, "queues.testaddress", "queue5", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(1, "queues.testaddress", "queue7", null, false);
        this.createQueue(1, "queues.testaddress", "queue8", null, false);
        this.createQueue(1, "queues.testaddress", "queue9", null, false);
        this.createQueue(1, "queues.testaddress", "queue10", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.createQueue(1, "queues.testaddress", "queue12", null, false);
        this.addConsumer(5, 1, "queue5", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 1, "queue7", null);
        this.addConsumer(8, 1, "queue8", null);
        this.addConsumer(9, 1, "queue9", null);
        this.addConsumer(11, 1, "queue10", null);
        this.addConsumer(13, 1, "queue11", null);
        this.addConsumer(15, 1, "queue12", null);
        this.waitForBindings(0, "queues.testaddress", 8, 8, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.verifyReceiveRoundRobin(10, 10, 11);
        this.verifyReceiveRoundRobin(10, 12, 13);
        this.verifyReceiveRoundRobin(10, 14, 15);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);
    }

    @Test
    public void testNotRouteToNonMatchingAddress() throws Exception {
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress2", "queue2", null, false);
        this.createQueue(1, "queues.testaddress2", "queue2", null, false);
        this.createQueue(0, "queues.testaddress2", "queue3", null, false);
        this.createQueue(1, "queues.testaddress2", "queue4", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue1", null);
        this.addConsumer(2, 0, "queue2", null);
        this.addConsumer(3, 1, "queue2", null);
        this.addConsumer(4, 0, "queue3", null);
        this.addConsumer(5, 1, "queue4", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(0, "queues.testaddress2", 2, 2, true);
        this.waitForBindings(0, "queues.testaddress2", 2, 2, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1);
        this.verifyNotReceive(2, 3, 4, 5);
    }

    @Test
    public void testNonLoadBalancedQueuesWithFilters() throws Exception {
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        String filter1 = "giraffe";
        String filter2 = "aardvark";
        this.createQueue(0, "queues.testaddress", "queue0", filter1, false);
        this.createQueue(0, "queues.testaddress", "queue1", filter2, false);
        this.createQueue(0, "queues.testaddress", "queue2", filter1, false);
        this.createQueue(0, "queues.testaddress", "queue3", filter2, false);
        this.createQueue(0, "queues.testaddress", "queue4", filter1, false);
        this.createQueue(1, "queues.testaddress", "queue5", filter2, false);
        this.createQueue(1, "queues.testaddress", "queue6", filter1, false);
        this.createQueue(1, "queues.testaddress", "queue7", filter2, false);
        this.createQueue(1, "queues.testaddress", "queue8", filter1, false);
        this.createQueue(1, "queues.testaddress", "queue9", filter2, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 0, "queue2", null);
        this.addConsumer(3, 0, "queue3", null);
        this.addConsumer(4, 0, "queue4", null);
        this.addConsumer(5, 1, "queue5", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 1, "queue7", null);
        this.addConsumer(8, 1, "queue8", null);
        this.addConsumer(9, 1, "queue9", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(11, 1, "queue11", null);
        this.waitForBindings(0, "queues.testaddress", 6, 6, true);
        this.waitForBindings(0, "queues.testaddress", 6, 6, false);
        this.send(0, "queues.testaddress", 10, false, filter1);
        this.verifyReceiveAll(10, 0, 2, 4, 6, 8, 10, 11);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
        this.send(0, "queues.testaddress", 10, false, filter2);
        this.verifyReceiveAll(10, 1, 3, 5, 7, 9, 10, 11);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 10, 11);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
    }

    @Test
    public void testRoundRobinMultipleQueuesWithFilters() throws Exception {
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        String filter1 = "giraffe";
        String filter2 = "aardvark";
        this.createQueue(0, "queues.testaddress", "queue0", filter1, false);
        this.createQueue(1, "queues.testaddress", "queue0", filter1, false);
        this.createQueue(0, "queues.testaddress", "queue1", filter1, false);
        this.createQueue(1, "queues.testaddress", "queue1", filter2, false);
        this.createQueue(0, "queues.testaddress", "queue2", filter2, false);
        this.createQueue(1, "queues.testaddress", "queue2", filter1, false);
        this.createQueue(0, "queues.testaddress", "queue3", filter2, false);
        this.createQueue(1, "queues.testaddress", "queue3", filter2, false);
        this.createQueue(0, "queues.testaddress", "queue4", null, false);
        this.createQueue(1, "queues.testaddress", "queue4", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 0, "queue1", null);
        this.addConsumer(3, 1, "queue1", null);
        this.addConsumer(4, 0, "queue2", null);
        this.addConsumer(5, 1, "queue2", null);
        this.addConsumer(6, 0, "queue3", null);
        this.addConsumer(7, 1, "queue3", null);
        this.addConsumer(8, 0, "queue4", null);
        this.addConsumer(9, 1, "queue4", null);
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(0, "queues.testaddress", 5, 5, false);
        this.send(0, "queues.testaddress", 10, false, filter1);
        this.verifyReceiveRoundRobin(10, 0, 1);
        this.verifyReceiveRoundRobin(10, 8, 9);
        this.verifyReceiveAll(10, 2, 5);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.send(0, "queues.testaddress", 10, false, filter2);
        this.verifyReceiveRoundRobin(10, 6, 7);
        this.verifyReceiveRoundRobin(10, 8, 9);
        this.verifyReceiveAll(10, 3, 4);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobin(10, 8, 9);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    }

    @Test
    public void testRouteWhenNoConsumersFalseNonBalancedQueues() throws Exception {
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(1, "queues.testaddress", "queue3", null, false);
        this.createQueue(1, "queues.testaddress", "queue4", null, false);
        this.createQueue(1, "queues.testaddress", "queue5", null, false);
        this.waitForBindings(0, "queues.testaddress", 3, 0, true);
        this.waitForBindings(0, "queues.testaddress", 3, 0, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 0, "queue2", null);
        this.addConsumer(3, 1, "queue3", null);
        this.addConsumer(4, 1, "queue4", null);
        this.addConsumer(5, 1, "queue5", null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5);
    }

    @Test
    public void testRouteWhenNoConsumersTrueNonBalancedQueues() throws Exception {
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(1, "queues.testaddress", "queue3", null, false);
        this.createQueue(1, "queues.testaddress", "queue4", null, false);
        this.createQueue(1, "queues.testaddress", "queue5", null, false);
        this.waitForBindings(0, "queues.testaddress", 3, 0, true);
        this.waitForBindings(0, "queues.testaddress", 3, 0, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 0, "queue2", null);
        this.addConsumer(3, 1, "queue3", null);
        this.addConsumer(4, 1, "queue4", null);
        this.addConsumer(5, 1, "queue5", null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5);
    }

    @Test
    public void testRouteWhenNoConsumersFalseLoadBalancedQueues() throws Exception {
        this.setupCluster(MessageLoadBalancingType.STRICT);
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(1, "queues.testaddress", "queue2", null, false);
        this.waitForBindings(0, "queues.testaddress", 3, 0, true);
        this.waitForBindings(0, "queues.testaddress", 3, 0, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 0, "queue2", null);
        this.addConsumer(3, 1, "queue0", null);
        this.addConsumer(4, 1, "queue1", null);
        this.addConsumer(5, 1, "queue2", null);
        this.verifyReceiveRoundRobin(10, 0, 3);
        this.verifyReceiveRoundRobin(10, 1, 4);
        this.verifyReceiveRoundRobin(10, 2, 5);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5);
    }

    @Test
    public void testRouteWhenNoConsumersFalseLoadBalancedQueuesLocalConsumer() throws Exception {
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(1, "queues.testaddress", "queue2", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 0, "queue2", null);
        this.waitForBindings(0, "queues.testaddress", 3, 3, true);
        this.waitForBindings(0, "queues.testaddress", 3, 0, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.addConsumer(3, 1, "queue0", null);
        this.addConsumer(4, 1, "queue1", null);
        this.addConsumer(5, 1, "queue2", null);
        this.verifyReceiveAll(10, 0, 1, 2);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5);
    }

    @Test
    public void testRouteWhenNoConsumersFalseLoadBalancedQueuesNoLocalQueue() throws Exception {
        this.setupCluster(MessageLoadBalancingType.STRICT);
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.waitForBindings(0, "queues.testaddress", 2, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 0, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 1, "queue0", null);
        this.addConsumer(3, 1, "queue1", null);
        this.verifyReceiveRoundRobin(10, 0, 2);
        this.verifyReceiveRoundRobin(10, 1, 3);
        this.verifyNotReceive(0, 1, 2, 3);
    }

    @Test
    public void testRouteWhenNoConsumersTrueLoadBalancedQueues() throws Exception {
        this.setupCluster(MessageLoadBalancingType.STRICT);
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(1, "queues.testaddress", "queue2", null, false);
        this.waitForBindings(0, "queues.testaddress", 3, 0, true);
        this.waitForBindings(0, "queues.testaddress", 3, 0, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 0, "queue2", null);
        this.addConsumer(3, 1, "queue0", null);
        this.addConsumer(4, 1, "queue1", null);
        this.addConsumer(5, 1, "queue2", null);
        this.verifyReceiveRoundRobin(10, 0, 3);
        this.verifyReceiveRoundRobin(10, 1, 4);
        this.verifyReceiveRoundRobin(10, 2, 5);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5);
    }

    @Test
    public void testRouteWhenNoConsumersTrueLoadBalancedQueuesLocalConsumer() throws Exception {
        this.servers[0].getConfiguration().getClusterConfigurations().clear();
        this.setupClusterConnection("cluster1", 0, 1, "queues", MessageLoadBalancingType.STRICT, 1, this.isNetty(), true);
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(1, "queues.testaddress", "queue2", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 0, "queue2", null);
        this.waitForBindings(0, "queues.testaddress", 3, 3, true);
        this.waitForBindings(0, "queues.testaddress", 3, 0, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.addConsumer(3, 1, "queue0", null);
        this.addConsumer(4, 1, "queue1", null);
        this.addConsumer(5, 1, "queue2", null);
        this.verifyReceiveRoundRobin(10, 0, 3);
        this.verifyReceiveRoundRobin(10, 1, 4);
        this.verifyReceiveRoundRobin(10, 2, 5);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5);
    }

    @Test
    public void testRouteWhenNoConsumersTrueLoadBalancedQueuesNoLocalQueue() throws Exception {
        this.servers[0].getConfiguration().getClusterConfigurations().clear();
        this.setupClusterConnection("cluster1", 0, 1, "queues", MessageLoadBalancingType.STRICT, 1, this.isNetty(), true);
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.waitForBindings(0, "queues.testaddress", 2, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 0, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 1, "queue0", null);
        this.addConsumer(3, 1, "queue1", null);
        this.verifyReceiveRoundRobin(10, 0, 2);
        this.verifyReceiveRoundRobin(10, 1, 3);
        this.verifyNotReceive(0, 1, 2, 3);
    }

    @Test
    public void testNonLoadBalancedQueuesWithConsumersWithFilters() throws Exception {
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        String filter1 = "giraffe";
        String filter2 = "aardvark";
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(0, "queues.testaddress", "queue3", null, false);
        this.createQueue(0, "queues.testaddress", "queue4", null, false);
        this.createQueue(1, "queues.testaddress", "queue5", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(1, "queues.testaddress", "queue7", null, false);
        this.createQueue(1, "queues.testaddress", "queue8", null, false);
        this.createQueue(1, "queues.testaddress", "queue9", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.addConsumer(0, 0, "queue0", filter1);
        this.addConsumer(1, 0, "queue1", filter2);
        this.addConsumer(2, 0, "queue2", filter1);
        this.addConsumer(3, 0, "queue3", filter2);
        this.addConsumer(4, 0, "queue4", filter1);
        this.addConsumer(5, 1, "queue5", filter2);
        this.addConsumer(6, 1, "queue6", filter1);
        this.addConsumer(7, 1, "queue7", filter2);
        this.addConsumer(8, 1, "queue8", filter1);
        this.addConsumer(9, 1, "queue9", filter2);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(11, 1, "queue11", null);
        this.waitForBindings(0, "queues.testaddress", 6, 6, true);
        this.waitForBindings(0, "queues.testaddress", 6, 6, false);
        this.send(0, "queues.testaddress", 10, false, filter1);
        this.verifyReceiveAll(10, 0, 2, 4, 6, 8, 10, 11);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
        this.send(0, "queues.testaddress", 10, false, filter2);
        this.verifyReceiveAll(10, 1, 3, 5, 7, 9, 10, 11);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
    }

    @Test
    public void testRoundRobinMultipleQueuesWithConsumersWithFilters() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        String filter1 = "giraffe";
        String filter2 = "aardvark";
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(1, "queues.testaddress", "queue2", null, false);
        this.createQueue(0, "queues.testaddress", "queue3", null, false);
        this.createQueue(1, "queues.testaddress", "queue3", null, false);
        this.createQueue(0, "queues.testaddress", "queue4", null, false);
        this.createQueue(1, "queues.testaddress", "queue4", null, false);
        this.addConsumer(0, 0, "queue0", filter1);
        this.addConsumer(1, 1, "queue0", filter1);
        this.addConsumer(2, 0, "queue1", filter1);
        this.addConsumer(3, 1, "queue1", filter2);
        this.addConsumer(4, 0, "queue2", filter2);
        this.addConsumer(5, 1, "queue2", filter1);
        this.addConsumer(6, 0, "queue3", filter2);
        this.addConsumer(7, 1, "queue3", filter2);
        this.addConsumer(8, 0, "queue4", null);
        this.addConsumer(9, 1, "queue4", null);
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(0, "queues.testaddress", 5, 5, false);
        this.send(0, "queues.testaddress", 10, false, filter1);
        this.verifyReceiveRoundRobin(10, 0, 1);
        this.verifyReceiveRoundRobin(10, 8, 9);
        this.verifyReceiveAll(10, 2, 5);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.send(0, "queues.testaddress", 10, false, filter2);
        this.verifyReceiveRoundRobin(10, 7, 6);
        this.verifyReceiveRoundRobin(10, 8, 9);
        this.verifyReceiveAll(10, 3, 4);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobin(10, 8, 9);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    }

    @Test
    public void testMultipleClusterConnections() throws Exception {
        this.setupClusterConnection("cluster2", 0, 1, "q2", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), true);
        this.setupClusterConnection("cluster3", 0, 1, "q3", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), true);
        this.startServers(1, 0);
        this.setupSessionFactory(0, this.isNetty(), true);
        this.setupSessionFactory(1, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "q2.testaddress", "queue2", null, false);
        this.createQueue(0, "q2.testaddress", "queue3", null, false);
        this.createQueue(0, "q3.testaddress", "queue4", null, false);
        this.createQueue(0, "q3.testaddress", "queue5", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(1, "queues.testaddress", "queue7", null, false);
        this.createQueue(1, "q2.testaddress", "queue8", null, false);
        this.createQueue(1, "q2.testaddress", "queue9", null, false);
        this.createQueue(1, "q3.testaddress", "queue10", null, false);
        this.createQueue(1, "q3.testaddress", "queue11", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 0, "queue2", null);
        this.addConsumer(3, 0, "queue3", null);
        this.addConsumer(4, 0, "queue4", null);
        this.addConsumer(5, 0, "queue5", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 1, "queue7", null);
        this.addConsumer(8, 1, "queue8", null);
        this.addConsumer(9, 1, "queue9", null);
        this.addConsumer(10, 1, "queue10", null);
        this.addConsumer(11, 1, "queue11", null);
        this.waitForBindings(0, "queues.testaddress", 2, 2, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(0, "q2.testaddress", 2, 2, true);
        this.waitForBindings(0, "q2.testaddress", 2, 2, false);
        this.waitForBindings(0, "q3.testaddress", 2, 2, true);
        this.waitForBindings(0, "q3.testaddress", 2, 2, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 6, 7);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
        this.send(0, "q2.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 2, 3, 8, 9);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
        this.send(0, "q3.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 4, 5, 10, 11);
        this.verifyNotReceive(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
    }
}

