/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.federation;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationQueuePolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationUpstreamConfiguration;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.integration.federation.FederatedTestBase;
import org.apache.activemq.artemis.tests.integration.federation.FederatedTestUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RetryRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class FederatedQueueTest
extends FederatedTestBase {
    @Rule
    public RetryRule retryRule = new RetryRule(1);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void configureQueues(ActiveMQServer server) throws Exception {
        server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false)));
        this.createSimpleQueue(server, this.getName());
    }

    protected ConnectionFactory getCF(int i) throws Exception {
        return new ActiveMQConnectionFactory("vm://" + i);
    }

    @Test
    public void testFederatedQueueRemoteConsumeUpstream() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createQueueUpstreamFederationConfiguration("server1", queueName);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(0).getFederationManager().deploy();
        this.testFederatedQueueRemoteConsume(queueName);
    }

    @Test
    public void testFederatedQueueRemoteConsumeUpstreamPriorityAdjustment() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createQueueUpstreamFederationConfiguration("server1", queueName);
        FederationQueuePolicyConfiguration policy = (FederationQueuePolicyConfiguration)federationConfiguration.getFederationPolicyMap().get("QueuePolicy" + queueName);
        policy.setPriorityAdjustment(Integer.valueOf(1));
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(0).getFederationManager().deploy();
        this.testFederatedQueueRemoteConsumeUpstreamPriorityAdjustment(queueName);
    }

    @Test
    public void testFederatedQueueRemoteConsumeDownstreamPriorityAdjustment() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createQueueDownstreamFederationConfiguration("server0", queueName, "server1");
        FederationQueuePolicyConfiguration policy = (FederationQueuePolicyConfiguration)federationConfiguration.getFederationPolicyMap().get("QueuePolicy" + queueName);
        policy.setPriorityAdjustment(Integer.valueOf(1));
        this.getServer(1).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(1).getFederationManager().deploy();
        this.testFederatedQueueRemoteConsumeUpstreamPriorityAdjustment(queueName);
    }

    private void testFederatedQueueRemoteConsumeUpstreamPriorityAdjustment(String queueName) throws Exception {
        ConnectionFactory cf1 = this.getCF(1);
        ConnectionFactory cf0 = this.getCF(0);
        try (Connection connection1 = cf1.createConnection();
             Connection connection0 = cf0.createConnection();){
            connection0.start();
            connection1.start();
            Session session0 = connection0.createSession();
            Session session1 = connection1.createSession();
            Queue queue0 = session0.createQueue(queueName);
            Queue queue1 = session1.createQueue(queueName);
            MessageConsumer consumer1 = session1.createConsumer((Destination)queue1);
            Wait.waitFor(() -> this.getConsumerCount(this.getServer(1), queueName, 1));
            MessageConsumer consumer0 = session0.createConsumer((Destination)queue0);
            Wait.waitFor(() -> this.getConsumerCount(this.getServer(1), queueName, 2));
            MessageProducer producer1 = session1.createProducer((Destination)queue1);
            producer1.send((Message)session1.createTextMessage("hello"));
            FederatedQueueTest.assertNull((Object)consumer1.receiveNoWait());
            FederatedQueueTest.assertNotNull((Object)consumer0.receive(1000L));
            consumer0.close();
            consumer1.close();
        }
    }

    private void verifyTransformer(String queueName) throws Exception {
        ConnectionFactory cf1 = this.getCF(1);
        ConnectionFactory cf0 = this.getCF(0);
        try (Connection connection1 = cf1.createConnection();
             Connection connection0 = cf0.createConnection();){
            connection1.start();
            Session session1 = connection1.createSession();
            Queue queue1 = session1.createQueue(queueName);
            MessageProducer producer1 = session1.createProducer((Destination)queue1);
            producer1.send((Message)session1.createTextMessage("hello"));
            connection0.start();
            Session session0 = connection0.createSession();
            Queue queue0 = session0.createQueue(queueName);
            MessageConsumer consumer0 = session0.createConsumer((Destination)queue0);
            Message message = consumer0.receive(1000L);
            FederatedQueueTest.assertNotNull((Object)message);
            FederatedQueueTest.assertEquals((Object)message.getBooleanProperty(TestTransformer.TEST_PROPERTY), (Object)true);
        }
    }

    @Test
    public void testFederatedQueueRemoteConsumeUpstreamTransformer() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createQueueUpstreamFederationConfiguration("server1", queueName);
        FederatedTestUtil.addQueueTransformerConfiguration(federationConfiguration, queueName);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(0).getFederationManager().deploy();
        this.verifyTransformer(queueName);
    }

    @Test
    public void testFederatedQueueRemoteConsumeDownstream() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createQueueDownstreamFederationConfiguration("server0", queueName, "server1");
        this.getServer(1).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(1).getFederationManager().deploy();
        this.testFederatedQueueRemoteConsume(queueName);
    }

    @Test
    public void testFederatedQueueRemoteConsumeDownstreamTransformer() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createQueueDownstreamFederationConfiguration("server0", queueName, "server1");
        FederatedTestUtil.addQueueTransformerConfiguration(federationConfiguration, queueName);
        this.getServer(1).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(1).getFederationManager().deploy();
        this.verifyTransformer(queueName);
    }

    private void testFederatedQueueRemoteConsume(String queueName) throws Exception {
        ConnectionFactory cf1 = this.getCF(1);
        ConnectionFactory cf0 = this.getCF(0);
        try (Connection connection1 = cf1.createConnection();
             Connection connection0 = cf0.createConnection();){
            connection1.start();
            Session session1 = connection1.createSession();
            Queue queue1 = session1.createQueue(queueName);
            MessageProducer producer = session1.createProducer((Destination)queue1);
            producer.send((Message)session1.createTextMessage("hello"));
            connection0.start();
            Session session0 = connection0.createSession();
            Queue queue0 = session0.createQueue(queueName);
            MessageConsumer consumer0 = session0.createConsumer((Destination)queue0);
            FederatedQueueTest.assertNotNull((Object)consumer0.receive(1000L));
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedQueueTest.assertNotNull((Object)consumer0.receive(1000L));
            MessageConsumer consumer1 = session1.createConsumer((Destination)queue1);
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedQueueTest.assertNotNull((Object)consumer1.receive(1000L));
            FederatedQueueTest.assertNull((Object)consumer0.receiveNoWait());
            consumer1.close();
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedQueueTest.assertNotNull((Object)consumer0.receive(1000L));
            producer.send(this.createTextMessage(session1, "groupA"));
            FederatedQueueTest.assertNotNull((Object)consumer0.receive(1000L));
            consumer1 = session1.createConsumer((Destination)queue1);
            producer.send(this.createTextMessage(session1, "groupA"));
            FederatedQueueTest.assertNull((Object)consumer1.receiveNoWait());
            FederatedQueueTest.assertNotNull((Object)consumer0.receive(1000L));
        }
    }

    @Test
    public void testFederatedQueueRemoteConsumeDeployAfterConsumersExist() throws Exception {
        String queueName = this.getName();
        ConnectionFactory cf0 = this.getCF(0);
        ConnectionFactory cf1 = this.getCF(1);
        try (Connection connection0 = cf0.createConnection();
             Connection connection1 = cf1.createConnection();){
            connection1.start();
            Session session1 = connection1.createSession();
            Queue queue1 = session1.createQueue(queueName);
            MessageProducer producer = session1.createProducer((Destination)queue1);
            producer.send((Message)session1.createTextMessage("hello"));
            connection0.start();
            Session session0 = connection0.createSession();
            Queue queue0 = session0.createQueue(queueName);
            MessageConsumer consumer0 = session0.createConsumer((Destination)queue0);
            FederatedQueueTest.assertNull((Object)consumer0.receiveNoWait());
            FederationConfiguration federationConfiguration = FederatedTestUtil.createQueueUpstreamFederationConfiguration("server1", queueName);
            this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
            this.getServer(0).getFederationManager().deploy();
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedQueueTest.assertNotNull((Object)consumer0.receive(10000L));
        }
    }

    @Test
    public void testFederatedQueueBiDirectionalUpstream() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration0 = FederatedTestUtil.createQueueUpstreamFederationConfiguration("server1", queueName);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration0);
        this.getServer(0).getFederationManager().deploy();
        FederationConfiguration federationConfiguration1 = FederatedTestUtil.createQueueUpstreamFederationConfiguration("server0", queueName);
        this.getServer(1).getConfiguration().getFederationConfigurations().add(federationConfiguration1);
        this.getServer(1).getFederationManager().deploy();
        this.testFederatedQueueBiDirectional(queueName, false);
    }

    @Test
    public void testFederatedQueueBiDirectionalDownstream() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration0 = FederatedTestUtil.createQueueDownstreamFederationConfiguration("server1", queueName, "server0");
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration0);
        this.getServer(0).getFederationManager().deploy();
        FederationConfiguration federationConfiguration1 = FederatedTestUtil.createQueueDownstreamFederationConfiguration("server0", queueName, "server1");
        this.getServer(1).getConfiguration().getFederationConfigurations().add(federationConfiguration1);
        this.getServer(1).getFederationManager().deploy();
        this.testFederatedQueueBiDirectional(queueName, false);
    }

    @Test
    public void testFederatedQueueBiDirectionalDownstreamUpstream() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration0 = FederatedTestUtil.createQueueDownstreamFederationConfiguration("server1-downstream", "server1", queueName, null, false, "server0");
        FederationUpstreamConfiguration upstreamConfig = FederatedTestUtil.createQueueFederationUpstream("server1", queueName);
        federationConfiguration0.addUpstreamConfiguration(upstreamConfig);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration0);
        this.getServer(0).getFederationManager().deploy();
        this.testFederatedQueueBiDirectional(queueName, false);
    }

    @Test
    public void testFederatedQueueBiDirectionalDownstreamUpstreamSharedConnection() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration0 = FederatedTestUtil.createQueueDownstreamFederationConfiguration("server1-downstream", "server1", queueName, null, true, "server0");
        FederationUpstreamConfiguration upstreamConfig = FederatedTestUtil.createQueueFederationUpstream("server1", queueName);
        upstreamConfig.getConnectionConfiguration().setShareConnection(true);
        federationConfiguration0.addUpstreamConfiguration(upstreamConfig);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration0);
        this.getServer(0).getFederationManager().deploy();
        this.testFederatedQueueBiDirectional(queueName, true);
    }

    @Test
    public void testFederatedQueueShareUpstreamConnectionFalse() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration0 = FederatedTestUtil.createQueueDownstreamFederationConfiguration("server1-downstream", "server1", queueName, null, false, "server0");
        federationConfiguration0.addUpstreamConfiguration(FederatedTestUtil.createQueueFederationUpstream("server1", queueName));
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration0);
        this.getServer(0).getFederationManager().deploy();
        this.testFederatedQueueShareUpstreamConnection(queueName, 2, 3);
    }

    @Test
    public void testFederatedQueueShareUpstreamConnectionTrue() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration0 = FederatedTestUtil.createQueueDownstreamFederationConfiguration("server1-downstream", "server1", queueName, null, true, "server0");
        FederationUpstreamConfiguration upstreamConfiguration = FederatedTestUtil.createQueueFederationUpstream("server1", queueName);
        upstreamConfiguration.getConnectionConfiguration().setShareConnection(true);
        federationConfiguration0.addUpstreamConfiguration(upstreamConfiguration);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration0);
        this.getServer(0).getFederationManager().deploy();
        this.testFederatedQueueShareUpstreamConnection(queueName, 2, 2);
    }

    private void testFederatedQueueShareUpstreamConnection(String queueName, int server0Connections, int server1Connections) throws Exception {
        ConnectionFactory cf1 = this.getCF(1);
        ConnectionFactory cf0 = this.getCF(0);
        try (Connection connection1 = cf1.createConnection();
             Connection connection0 = cf0.createConnection();){
            connection0.start();
            connection1.start();
            Session session0 = connection0.createSession();
            Session session1 = connection1.createSession();
            MessageConsumer consumer0 = session0.createConsumer((Destination)session0.createQueue(queueName));
            MessageConsumer consumer1 = session1.createConsumer((Destination)session1.createQueue(queueName));
            FederatedQueueTest.assertTrue((boolean)Wait.waitFor(() -> this.getServer(0).getConnectionCount() == server0Connections, (long)500L, (long)100L));
            FederatedQueueTest.assertTrue((boolean)Wait.waitFor(() -> this.getServer(1).getConnectionCount() == server1Connections, (long)500L, (long)100L));
            FederatedQueueTest.assertFalse((boolean)Wait.waitFor(() -> this.getServer(0).getConnectionCount() > server0Connections, (long)500L, (long)100L));
            FederatedQueueTest.assertFalse((boolean)Wait.waitFor(() -> this.getServer(1).getConnectionCount() > server1Connections, (long)500L, (long)100L));
        }
    }

    private void testFederatedQueueBiDirectional(String queueName, boolean shared) throws Exception {
        ConnectionFactory cf1 = this.getCF(1);
        ConnectionFactory cf0 = this.getCF(0);
        try (Connection connection1 = cf1.createConnection();
             Connection connection0 = cf0.createConnection();){
            connection0.start();
            Session session0 = connection0.createSession();
            Queue queue0 = session0.createQueue(queueName);
            MessageProducer producer0 = session0.createProducer((Destination)queue0);
            connection1.start();
            Session session1 = connection1.createSession();
            Queue queue1 = session1.createQueue(queueName);
            MessageProducer producer1 = session1.createProducer((Destination)queue1);
            MessageConsumer consumer0 = session0.createConsumer((Destination)queue0);
            producer0.send((Message)session1.createTextMessage("hello"));
            FederatedQueueTest.assertNotNull((Object)consumer0.receive(1000L));
            producer1.send((Message)session1.createTextMessage("hello"));
            FederatedQueueTest.assertNotNull((Object)consumer0.receive(1000L));
            Wait.assertTrue(() -> this.getServer(0).getPostOffice().getBinding(SimpleString.toSimpleString((String)queueName)) != null);
            Wait.assertTrue(() -> this.getServer(1).getPostOffice().getBinding(SimpleString.toSimpleString((String)queueName)) != null);
            FederatedQueueTest.assertFalse((boolean)Wait.waitFor(() -> this.getServer(0).locateQueue(SimpleString.toSimpleString((String)queueName)).getConsumerCount() > 1, (long)500L, (long)100L));
            FederatedQueueTest.assertFalse((boolean)Wait.waitFor(() -> this.getServer(1).locateQueue(SimpleString.toSimpleString((String)queueName)).getConsumerCount() > 1, (long)500L, (long)100L));
            int server1ConsumerCount = this.getServer(1).getConnectionCount();
            consumer0.close();
            Wait.waitFor(() -> ((QueueBinding)this.getServer(0).getPostOffice().getBinding(SimpleString.toSimpleString((String)queueName))).consumerCount() == 0, (long)1000L);
            if (shared) {
                FederatedQueueTest.assertFalse((boolean)Wait.waitFor(() -> this.getServer(1).getConnectionCount() == server1ConsumerCount - 1, (long)500L, (long)100L));
                FederatedQueueTest.assertTrue((server1ConsumerCount == this.getServer(1).getConnectionCount() ? (byte)1 : 0) != 0);
            }
            MessageConsumer consumer1 = session1.createConsumer((Destination)queue1);
            producer0.send((Message)session1.createTextMessage("hello"));
            FederatedQueueTest.assertNotNull((Object)consumer1.receive(1000L));
            producer1.send((Message)session1.createTextMessage("hello"));
            FederatedQueueTest.assertNotNull((Object)consumer1.receive(1000L));
            consumer0 = session0.createConsumer((Destination)queue0);
            producer0.send((Message)session1.createTextMessage("produce0"));
            producer1.send((Message)session1.createTextMessage("produce1"));
            Message message0 = consumer0.receive(1000L);
            FederatedQueueTest.assertNotNull((Object)message0);
            FederatedQueueTest.assertEquals((Object)"produce0", (Object)((TextMessage)message0).getText());
            Message message1 = consumer1.receive(1000L);
            FederatedQueueTest.assertNotNull((Object)message1);
            FederatedQueueTest.assertEquals((Object)"produce1", (Object)((TextMessage)message1).getText());
        }
    }

    @Test
    public void testFederatedQueueChainOfBrokers() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration0 = FederatedTestUtil.createQueueUpstreamFederationConfiguration("server1", queueName, true);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration0);
        this.getServer(0).getFederationManager().deploy();
        FederationConfiguration federationConfiguration1 = FederatedTestUtil.createQueueUpstreamFederationConfiguration("server2", queueName, true);
        this.getServer(1).getConfiguration().getFederationConfigurations().add(federationConfiguration1);
        this.getServer(1).getFederationManager().deploy();
        ConnectionFactory cf2 = this.getCF(2);
        ConnectionFactory cf0 = this.getCF(0);
        try (Connection connection2 = cf2.createConnection();
             Connection connection0 = cf0.createConnection();){
            connection0.start();
            Session session0 = connection0.createSession();
            Queue queue0 = session0.createQueue(queueName);
            connection2.start();
            Session session2 = connection2.createSession();
            Queue queue2 = session2.createQueue(queueName);
            MessageProducer producer2 = session2.createProducer((Destination)queue2);
            MessageConsumer consumer0 = session0.createConsumer((Destination)queue0);
            producer2.send((Message)session2.createTextMessage("hello"));
            FederatedQueueTest.assertNotNull((Object)consumer0.receive(1000L));
        }
    }

    @Test
    public void testFederatedQueueRemoteBrokerRestart() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createQueueUpstreamFederationConfiguration("server1", queueName);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(0).getFederationManager().deploy();
        ConnectionFactory cf1 = this.getCF(1);
        Connection connection1 = cf1.createConnection();
        connection1.start();
        Session session1 = connection1.createSession();
        Queue queue1 = session1.createQueue(queueName);
        MessageProducer producer = session1.createProducer((Destination)queue1);
        producer.send((Message)session1.createTextMessage("hello"));
        ConnectionFactory cf0 = this.getCF(0);
        Connection connection0 = cf0.createConnection();
        connection0.start();
        Session session0 = connection0.createSession();
        Queue queue0 = session0.createQueue(queueName);
        MessageConsumer consumer0 = session0.createConsumer((Destination)queue0);
        FederatedQueueTest.assertNotNull((Object)consumer0.receive(1000L));
        producer.send((Message)session1.createTextMessage("hello"));
        FederatedQueueTest.assertNotNull((Object)consumer0.receive(1000L));
        connection1.close();
        this.getServer(1).stop();
        FederatedQueueTest.assertNull((Object)consumer0.receiveNoWait());
        this.getServer(1).start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.getServer(1)).isActive());
        this.createSimpleQueue(this.getServer(1), this.getName());
        connection1 = cf1.createConnection();
        connection1.start();
        session1 = connection1.createSession();
        queue1 = session1.createQueue(queueName);
        producer = session1.createProducer((Destination)queue1);
        producer.send((Message)session1.createTextMessage("hello"));
        Wait.waitFor(() -> this.getConsumerCount(this.getServer(1), queueName, 1));
        FederatedQueueTest.assertNotNull((Object)consumer0.receive(1000L));
    }

    private boolean getConsumerCount(ActiveMQServer server, String queueName, int count) {
        QueueBinding binding = (QueueBinding)server.getPostOffice().getBinding(SimpleString.toSimpleString((String)queueName));
        if (binding == null) {
            return false;
        }
        return binding.consumerCount() == count;
    }

    @Test
    public void testFederatedQueueLocalBrokerRestart() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createQueueUpstreamFederationConfiguration("server1", queueName);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(0).getFederationManager().deploy();
        ConnectionFactory cf1 = this.getCF(1);
        Connection connection1 = cf1.createConnection();
        connection1.start();
        Session session1 = connection1.createSession();
        Queue queue1 = session1.createQueue(queueName);
        MessageProducer producer = session1.createProducer((Destination)queue1);
        producer.send((Message)session1.createTextMessage("hello"));
        ConnectionFactory cf0 = this.getCF(0);
        Connection connection0 = cf0.createConnection();
        connection0.start();
        Session session0 = connection0.createSession();
        Queue queue0 = session0.createQueue(queueName);
        MessageConsumer consumer0 = session0.createConsumer((Destination)queue0);
        FederatedQueueTest.assertNotNull((Object)consumer0.receive(1000L));
        producer.send((Message)session1.createTextMessage("hello"));
        FederatedQueueTest.assertNotNull((Object)consumer0.receive(1000L));
        connection0.close();
        this.getServer(0).stop();
        producer.send((Message)session1.createTextMessage("hello"));
        this.getServer(0).start();
        Wait.waitFor(() -> this.getServer(0).isActive());
        this.createSimpleQueue(this.getServer(0), this.getName());
        connection0 = this.getCF(0).createConnection();
        connection0.start();
        session0 = connection0.createSession();
        queue0 = session0.createQueue(queueName);
        consumer0 = session0.createConsumer((Destination)queue0);
        producer.send((Message)session1.createTextMessage("hello"));
        Wait.assertTrue(() -> this.getServer(1).getPostOffice().getBinding(SimpleString.toSimpleString((String)queueName)) != null);
        Wait.waitFor(() -> ((QueueBinding)this.getServer(1).getPostOffice().getBinding(SimpleString.toSimpleString((String)queueName))).consumerCount() == 1);
        FederatedQueueTest.assertNotNull((Object)consumer0.receive(5000L));
    }

    private Message createTextMessage(Session session1, String group) throws JMSException {
        TextMessage message = session1.createTextMessage("hello");
        message.setStringProperty("JMSXGroupID", group);
        return message;
    }

    public static class TestTransformer
    implements Transformer {
        static String TEST_PROPERTY = "transformed";

        public org.apache.activemq.artemis.api.core.Message transform(org.apache.activemq.artemis.api.core.Message message) {
            message.putBooleanProperty(TEST_PROPERTY, true);
            return message;
        }
    }
}

