/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireDivertTestBase;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.junit.Assert;
import org.junit.Test;

public class OpenWireDivertExclusiveTest
extends OpenWireDivertTestBase {
    @Override
    protected boolean isExclusive() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleExclusiveDivert() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession coreSession = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        SimpleString queueName3 = new SimpleString("queue3");
        SimpleString queueName4 = new SimpleString("queue4");
        coreSession.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress").setDurable(Boolean.valueOf(false)));
        coreSession.createQueue(new QueueConfiguration(queueName2).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        coreSession.createQueue(new QueueConfiguration(queueName3).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        coreSession.createQueue(new QueueConfiguration(queueName4).setAddress("testAddress").setDurable(Boolean.valueOf(false)));
        ClientProducer producer = coreSession.createProducer(new SimpleString("testAddress"));
        int numMessages = 10;
        SimpleString propKey = new SimpleString("testkey");
        for (int i = 0; i < 10; ++i) {
            ClientMessage message = coreSession.createMessage(false);
            message.putIntProperty(propKey, i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        coreSession.close();
        this.factory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
        try (Connection openwireConnection = this.factory.createConnection();){
            Session session = openwireConnection.createSession(false, 1);
            openwireConnection.start();
            Queue q1 = session.createQueue(CompositeAddress.toFullyQualified((String)"forwardAddress", (String)"queue1"));
            Queue q2 = session.createQueue(CompositeAddress.toFullyQualified((String)"testAddress", (String)"queue2"));
            Queue q3 = session.createQueue(CompositeAddress.toFullyQualified((String)"testAddress", (String)"queue3"));
            Queue q4 = session.createQueue(CompositeAddress.toFullyQualified((String)"testAddress", (String)"queue4"));
            MessageConsumer consumer1 = session.createConsumer((Destination)q1);
            MessageConsumer consumer2 = session.createConsumer((Destination)q2);
            MessageConsumer consumer3 = session.createConsumer((Destination)q3);
            MessageConsumer consumer4 = session.createConsumer((Destination)q4);
            for (int i = 0; i < 10; ++i) {
                Message message = consumer1.receive(3000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)i, (Object)message.getObjectProperty(propKey.toString()));
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer1.receive(50L));
            Assert.assertNull((Object)consumer2.receive(50L));
            Assert.assertNull((Object)consumer3.receive(50L));
            Assert.assertNull((Object)consumer4.receive(50L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleExclusiveDivertOpenWirePublisher() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession coreSession = sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("queue1");
        SimpleString queueName2 = new SimpleString("queue2");
        coreSession.createQueue(new QueueConfiguration(queueName1).setAddress("forwardAddress").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        coreSession.createQueue(new QueueConfiguration(queueName2).setAddress("testAddress").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        coreSession.close();
        this.factory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
        try (Connection openwireConnection = this.factory.createConnection();){
            openwireConnection.start();
            Session session = openwireConnection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)session.createQueue("testAddress"));
            int numMessages = 10;
            String propKey = "testkey";
            for (int i = 0; i < 10; ++i) {
                Message message = session.createMessage();
                message.setIntProperty("testkey", i);
                producer.send(message);
            }
            Queue q1 = session.createQueue(CompositeAddress.toFullyQualified((String)"forwardAddress", (String)"queue1"));
            Queue q2 = session.createQueue(CompositeAddress.toFullyQualified((String)"testAddress", (String)"queue2"));
            MessageConsumer consumer1 = session.createConsumer((Destination)q1);
            MessageConsumer consumer2 = session.createConsumer((Destination)q2);
            for (int i = 0; i < 10; ++i) {
                Message message = consumer1.receive(3000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)i, (Object)message.getObjectProperty("testkey".toString()));
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer1.receive(50L));
            Assert.assertNull((Object)consumer2.receive(50L));
        }
    }
}

