/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.util.UUID;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PotentialOOMELoggingTest
extends ActiveMQTestBase {
    @BeforeClass
    public static void prepareLogger() {
        AssertionLoggerHandler.startCapture();
    }

    @Test
    public void testBlockLogging() throws Exception {
        ActiveMQServer server = this.createServer(false, this.createDefaultInVMConfig());
        for (int i = 0; i < 10000; ++i) {
            server.getConfiguration().addQueueConfiguration(new QueueConfiguration(UUID.randomUUID().toString()));
        }
        server.getConfiguration().setGlobalMaxSize(-1L);
        server.getConfiguration().getAddressesSettings().put("#", new AddressSettings().setMaxSizeBytes(0x6400000L));
        server.start();
        Assert.assertTrue((String)"Expected to find 222205", (boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ222205"}));
    }

    @AfterClass
    public static void clearLogger() {
        AssertionLoggerHandler.stopCapture();
    }
}

