/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.xa;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RetryRule;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SessionFailureXATest
extends ActiveMQTestBase {
    @Rule
    public RetryRule retryRule = new RetryRule(1);
    private final Map<String, AddressSettings> addressSettings = new HashMap<String, AddressSettings>();
    private ActiveMQServer messagingService;
    private ClientSession clientSession;
    private ClientSessionFactory sessionFactory;
    private Configuration configuration;
    private final SimpleString atestq = new SimpleString("BasicXaTestq");
    private ServerLocator locator;
    private StoreConfiguration.StoreType storeType;

    public SessionFailureXATest(StoreConfiguration.StoreType storeType) {
        this.storeType = storeType;
    }

    @Parameterized.Parameters(name="storeType={0}")
    public static Collection<Object[]> data() {
        Object[][] params = new Object[][]{{StoreConfiguration.StoreType.FILE}};
        return Arrays.asList(params);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.addressSettings.clear();
        this.configuration = this.storeType == StoreConfiguration.StoreType.DATABASE ? this.createDefaultJDBCConfig(true) : this.createDefaultNettyConfig();
        this.messagingService = this.createServer(true, this.configuration, -1, -1L, this.addressSettings);
        this.messagingService.start();
        this.locator = this.createInVMNonHALocator();
        this.locator.setAckBatchSize(0);
        this.sessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = this.addClientSession(this.sessionFactory.createSession(true, false, false));
        this.clientSession.createQueue(new QueueConfiguration(this.atestq));
    }

    @Test
    public void testFailureWithXAEnd() throws Exception {
        this.testFailure(true, false);
    }

    @Test
    public void testFailureWithoutXAEnd() throws Exception {
        this.testFailure(false, false);
    }

    @Test
    public void testFailureWithXAPrepare() throws Exception {
        this.testFailure(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailure(boolean xaEnd, boolean xaPrepare) throws Exception {
        try (ClientSession clientSession2 = this.sessionFactory.createSession(false, true, true);){
            ClientProducer clientProducer = clientSession2.createProducer(this.atestq);
            ClientMessage m1 = this.createTextMessage(clientSession2, "m1");
            ClientMessage m2 = this.createTextMessage(clientSession2, "m2");
            ClientMessage m3 = this.createTextMessage(clientSession2, "m3");
            ClientMessage m4 = this.createTextMessage(clientSession2, "m4");
            clientProducer.send((Message)m1);
            clientProducer.send((Message)m2);
            clientProducer.send((Message)m3);
            clientProducer.send((Message)m4);
        }
        XidImpl xid = this.newXID();
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.setTransactionTimeout((int)TimeUnit.MINUTES.toMillis(10L));
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(this.atestq);
        ClientMessage m = clientConsumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        m.acknowledge();
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = clientConsumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        m.acknowledge();
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = clientConsumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        m.acknowledge();
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = clientConsumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        m.acknowledge();
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        if (xaEnd) {
            this.clientSession.end((Xid)xid, 0x4000000);
            if (xaPrepare) {
                this.clientSession.prepare((Xid)xid);
            }
        }
        Wait.assertEquals((int)1, () -> this.messagingService.getSessions().size());
        for (ServerSession serverSession : this.messagingService.getSessions()) {
            serverSession.getRemotingConnection().fail(new ActiveMQException("fail this"));
            serverSession.getRemotingConnection().disconnect(false);
        }
        Wait.assertEquals((int)0, () -> this.messagingService.getSessions().size());
        if (xaPrepare) {
            Wait.assertEquals((int)1, () -> ((ResourceManager)this.messagingService.getResourceManager()).size());
        } else {
            Wait.assertEquals((int)0, () -> ((ResourceManager)this.messagingService.getResourceManager()).size());
        }
        this.locator = this.createInVMNonHALocator();
        this.sessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = this.addClientSession(this.sessionFactory.createSession(true, false, false));
        Wait.assertEquals((int)1, () -> this.messagingService.getSessions().size());
        xid = this.newXID();
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.setTransactionTimeout((int)TimeUnit.MINUTES.toMillis(10L));
        this.clientSession.start();
        clientConsumer = this.clientSession.createConsumer(this.atestq);
        HashSet<String> bodies = new HashSet<String>();
        m = clientConsumer.receive(1000L);
        if (xaPrepare) {
            Assert.assertNull((Object)m);
        } else {
            Assert.assertNotNull((Object)m);
            m.acknowledge();
            this.assertOrTrack(xaEnd, m, bodies, "m1");
            m = clientConsumer.receive(1000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
            this.assertOrTrack(xaEnd, m, bodies, "m2");
            m = clientConsumer.receive(1000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
            this.assertOrTrack(xaEnd, m, bodies, "m3");
            m = clientConsumer.receive(1000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
            this.assertOrTrack(xaEnd, m, bodies, "m4");
            if (!xaEnd) {
                SessionFailureXATest.assertEquals((String)"got all bodies", (long)4L, (long)bodies.size());
            }
        }
    }

    private void assertOrTrack(boolean xaEnd, ClientMessage m, HashSet<String> bodies, String expected) {
        String body = m.getBodyBuffer().readString();
        if (xaEnd) {
            Assert.assertEquals((Object)expected, (Object)body);
        } else {
            bodies.add(body);
        }
    }
}

