/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQBufferInputStream;
import org.junit.Test;

public class ActiveMQBufferInputStreamTest
extends ActiveMQTestBase {
    @Test
    public void testReadBytes() throws Exception {
        int i;
        byte[] bytes = new byte[10240];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            bytes[i2] = ActiveMQBufferInputStreamTest.getSamplebyte((long)i2);
        }
        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])bytes);
        ActiveMQBufferInputStream is = new ActiveMQBufferInputStream(buffer);
        for (i = 0; i < 1024; ++i) {
            ActiveMQBufferInputStreamTest.assertEquals((long)ActiveMQBufferInputStreamTest.getSamplebyte((long)i), (long)is.read());
        }
        for (i = 1; i < 10; ++i) {
            bytes = new byte[1024];
            is.read(bytes);
            for (int j = 0; j < bytes.length; ++j) {
                ActiveMQBufferInputStreamTest.assertEquals((long)ActiveMQBufferInputStreamTest.getSamplebyte((long)(i * 1024 + j)), (long)bytes[j]);
            }
        }
        ActiveMQBufferInputStreamTest.assertEquals((long)-1L, (long)is.read());
        bytes = new byte[1024];
        int sizeRead = is.read(bytes);
        ActiveMQBufferInputStreamTest.assertEquals((long)-1L, (long)sizeRead);
        is.close();
    }
}

