/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.impl;

import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.ReusableLatch;

public class Redistributor
implements Consumer {
    private boolean active;
    private final StorageManager storageManager;
    private final PostOffice postOffice;
    private final Queue queue;
    private final long sequentialID;
    private ReusableLatch pendingRuns = new ReusableLatch();

    public Redistributor(Queue queue, StorageManager storageManager, PostOffice postOffice) {
        this.queue = queue;
        this.sequentialID = storageManager.generateID();
        this.storageManager = storageManager;
        this.postOffice = postOffice;
    }

    @Override
    public long sequentialID() {
        return this.sequentialID;
    }

    @Override
    public Filter getFilter() {
        return null;
    }

    @Override
    public String debug() {
        return this.toString();
    }

    @Override
    public String toManagementString() {
        return "Redistributor[" + this.queue.getName() + "/" + this.queue.getID() + "]";
    }

    @Override
    public void disconnect() {
    }

    public synchronized void start() {
        this.active = true;
    }

    public synchronized void stop() throws Exception {
        this.active = false;
    }

    public synchronized void close() {
        this.active = false;
    }

    @Override
    public synchronized HandleStatus handle(MessageReference reference) throws Exception {
        if (!this.active) {
            return HandleStatus.BUSY;
        }
        if (reference.getMessage().getGroupID() != null) {
            return HandleStatus.NO_MATCH;
        }
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        Pair<RoutingContext, Message> routingInfo = this.postOffice.redistribute(reference.getMessage(), this.queue, tx);
        if (routingInfo == null) {
            tx.rollback();
            return HandleStatus.BUSY;
        }
        this.postOffice.processRoute((Message)routingInfo.getB(), (RoutingContext)routingInfo.getA(), false);
        this.ackRedistribution(reference, tx);
        return HandleStatus.HANDLED;
    }

    @Override
    public void proceedDeliver(MessageReference ref) {
    }

    private void ackRedistribution(MessageReference reference, Transaction tx) throws Exception {
        reference.handled();
        this.queue.acknowledge(tx, reference);
        tx.commit();
    }

    @Override
    public List<MessageReference> getDeliveringMessages() {
        return Collections.emptyList();
    }
}

