/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.codegen;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.Tool;
import org.antlr.v4.codegen.CodeGenerator;
import org.antlr.v4.codegen.UnicodeEscapes;
import org.antlr.v4.codegen.model.RuleFunction;
import org.antlr.v4.misc.CharSupport;
import org.antlr.v4.misc.Utils;
import org.antlr.v4.runtime.RuntimeMetaData;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ast.GrammarAST;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.NumberRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.StringRenderer;
import org.stringtemplate.v4.misc.STMessage;

public abstract class Target {
    protected final CodeGenerator gen;
    private STGroup templates;
    protected static final Map<Character, String> defaultCharValueEscape;

    protected Target(CodeGenerator gen) {
        this.gen = gen;
    }

    public Map<Character, String> getTargetCharValueEscape() {
        return defaultCharValueEscape;
    }

    protected static void addEscapedChar(HashMap<Character, String> map, char key) {
        Target.addEscapedChar(map, key, key);
    }

    protected static void addEscapedChar(HashMap<Character, String> map, char key, char representation) {
        map.put(Character.valueOf(key), "\\" + representation);
    }

    public String getLanguage() {
        return this.gen.language;
    }

    public CodeGenerator getCodeGenerator() {
        return this.gen;
    }

    public String getVersion() {
        return Tool.VERSION;
    }

    public STGroup getTemplates() {
        if (this.templates == null) {
            String version = this.getVersion();
            if (version == null || !RuntimeMetaData.getMajorMinorVersion((String)version).equals(RuntimeMetaData.getMajorMinorVersion((String)Tool.VERSION))) {
                this.gen.tool.errMgr.toolError(ErrorType.INCOMPATIBLE_TOOL_AND_TEMPLATES, version, Tool.VERSION, this.getLanguage());
            }
            this.templates = this.loadTemplates();
        }
        return this.templates;
    }

    protected abstract Set<String> getReservedWords();

    public String escapeIfNeeded(String identifier) {
        return this.getReservedWords().contains(identifier) ? this.escapeWord(identifier) : identifier;
    }

    protected String escapeWord(String word) {
        return word + "_";
    }

    protected void genFile(Grammar g, ST outputFileST, String fileName) {
        this.getCodeGenerator().write(outputFileST, fileName);
    }

    public String getTokenTypeAsTargetLabel(Grammar g, int ttype) {
        String name = g.getTokenName(ttype);
        if ("<INVALID>".equals(name)) {
            return String.valueOf(ttype);
        }
        return name;
    }

    public String[] getTokenTypesAsTargetLabels(Grammar g, int[] ttypes) {
        String[] labels = new String[ttypes.length];
        for (int i = 0; i < ttypes.length; ++i) {
            labels[i] = this.getTokenTypeAsTargetLabel(g, ttypes[i]);
        }
        return labels;
    }

    public String getTargetStringLiteralFromString(String s, boolean quoted) {
        int c;
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (quoted) {
            buf.append('\"');
        }
        for (int i = 0; i < s.length(); i += Character.charCount(c)) {
            String escaped;
            c = s.codePointAt(i);
            String string = escaped = c <= 65535 ? this.getTargetCharValueEscape().get(Character.valueOf((char)c)) : null;
            if (c != 39 && escaped != null) {
                buf.append(escaped);
                continue;
            }
            if (this.shouldUseUnicodeEscapeForCodePointInDoubleQuotedString(c)) {
                this.appendUnicodeEscapedCodePoint(i, buf);
                continue;
            }
            buf.appendCodePoint(c);
        }
        if (quoted) {
            buf.append('\"');
        }
        return buf.toString();
    }

    private void appendUnicodeEscapedCodePoint(int codePoint, StringBuilder sb, boolean escape) {
        if (escape) {
            sb.append("\\");
        }
        this.appendUnicodeEscapedCodePoint(codePoint, sb);
    }

    protected void appendUnicodeEscapedCodePoint(int codePoint, StringBuilder sb) {
        UnicodeEscapes.appendEscapedCodePoint(sb, codePoint, this.getLanguage());
    }

    public String getTargetStringLiteralFromString(String s) {
        return this.getTargetStringLiteralFromString(s, true);
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator generator, String literal, boolean addQuotes) {
        return this.getTargetStringLiteralFromANTLRStringLiteral(generator, literal, addQuotes, false);
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator generator, String literal, boolean addQuotes, boolean escapeSpecial) {
        int toAdvance;
        StringBuilder sb = new StringBuilder();
        if (addQuotes) {
            sb.append('\"');
        }
        block4: for (int i = 1; i < literal.length() - 1; i += toAdvance) {
            int codePoint = literal.codePointAt(i);
            toAdvance = Character.charCount(codePoint);
            if (codePoint == 92) {
                int escapedCodePoint = literal.codePointAt(i + toAdvance);
                ++toAdvance;
                switch (escapedCodePoint) {
                    case 92: 
                    case 98: 
                    case 102: 
                    case 110: 
                    case 114: 
                    case 116: {
                        if (escapeSpecial && escapedCodePoint != 92) {
                            sb.append('\\');
                        }
                        sb.append('\\');
                        sb.appendCodePoint(escapedCodePoint);
                        break;
                    }
                    case 117: {
                        if (literal.charAt(i + toAdvance) == '{') {
                            while (literal.charAt(i + toAdvance) != '}') {
                                ++toAdvance;
                            }
                            ++toAdvance;
                        } else {
                            toAdvance += 4;
                        }
                        if (i + toAdvance > literal.length()) continue block4;
                        String fullEscape = literal.substring(i, i + toAdvance);
                        this.appendUnicodeEscapedCodePoint(CharSupport.getCharValueFromCharInGrammarLiteral(fullEscape), sb, escapeSpecial);
                        break;
                    }
                    default: {
                        if (this.shouldUseUnicodeEscapeForCodePointInDoubleQuotedString(escapedCodePoint)) {
                            this.appendUnicodeEscapedCodePoint(escapedCodePoint, sb, escapeSpecial);
                            break;
                        }
                        sb.appendCodePoint(escapedCodePoint);
                        break;
                    }
                }
                continue;
            }
            if (codePoint == 34) {
                sb.append("\\\"");
                continue;
            }
            if (this.shouldUseUnicodeEscapeForCodePointInDoubleQuotedString(codePoint)) {
                this.appendUnicodeEscapedCodePoint(codePoint, sb, escapeSpecial);
                continue;
            }
            sb.appendCodePoint(codePoint);
        }
        if (addQuotes) {
            sb.append('\"');
        }
        return sb.toString();
    }

    protected boolean shouldUseUnicodeEscapeForCodePointInDoubleQuotedString(int codePoint) {
        assert (codePoint != 10 && codePoint != 34);
        return codePoint < 32 || codePoint == 92 || codePoint >= 127;
    }

    public String encodeInt16AsCharEscape(int v) {
        if (v < 0 || v > 65535) {
            throw new IllegalArgumentException(String.format("Cannot encode the specified value: %d", v));
        }
        if (this.isATNSerializedAsInts()) {
            return Integer.toString(v);
        }
        char c = (char)v;
        String escaped = this.getTargetCharValueEscape().get(Character.valueOf(c));
        if (escaped != null) {
            return escaped;
        }
        switch (Character.getType(c)) {
            case 13: 
            case 14: 
            case 15: {
                return this.escapeChar(v);
            }
        }
        if (v <= 127) {
            return String.valueOf(c);
        }
        return this.escapeChar(v);
    }

    protected String escapeChar(int v) {
        return String.format("\\u%04x", v);
    }

    public String getLoopLabel(GrammarAST ast) {
        return "loop" + ast.token.getTokenIndex();
    }

    public String getLoopCounter(GrammarAST ast) {
        return "cnt" + ast.token.getTokenIndex();
    }

    public String getListLabel(String label) {
        ST st = this.getTemplates().getInstanceOf("ListLabelName");
        st.add("label", (Object)label);
        return st.render();
    }

    public String getRuleFunctionContextStructName(Rule r) {
        if (r.g.isLexer()) {
            return this.getTemplates().getInstanceOf("LexerRuleContext").render();
        }
        return Utils.capitalize(r.name) + this.getTemplates().getInstanceOf("RuleContextNameSuffix").render();
    }

    public String getAltLabelContextStructName(String label) {
        return Utils.capitalize(label) + this.getTemplates().getInstanceOf("RuleContextNameSuffix").render();
    }

    public String getRuleFunctionContextStructName(RuleFunction function) {
        Rule r = function.rule;
        if (r.g.isLexer()) {
            return this.getTemplates().getInstanceOf("LexerRuleContext").render();
        }
        return Utils.capitalize(r.name) + this.getTemplates().getInstanceOf("RuleContextNameSuffix").render();
    }

    public String getImplicitTokenLabel(String tokenName) {
        ST st = this.getTemplates().getInstanceOf("ImplicitTokenLabel");
        int ttype = this.getCodeGenerator().g.getTokenType(tokenName);
        if (tokenName.startsWith("'")) {
            return "s" + ttype;
        }
        String text = this.getTokenTypeAsTargetLabel(this.getCodeGenerator().g, ttype);
        st.add("tokenName", (Object)text);
        return st.render();
    }

    public String getImplicitSetLabel(String id) {
        ST st = this.getTemplates().getInstanceOf("ImplicitSetLabel");
        st.add("id", (Object)id);
        return st.render();
    }

    public String getImplicitRuleLabel(String ruleName) {
        ST st = this.getTemplates().getInstanceOf("ImplicitRuleLabel");
        st.add("ruleName", (Object)ruleName);
        return st.render();
    }

    public String getElementListName(String name) {
        ST st = this.getTemplates().getInstanceOf("ElementListName");
        st.add("elemName", (Object)this.getElementName(name));
        return st.render();
    }

    public String getElementName(String name) {
        if (".".equals(name)) {
            return "_wild";
        }
        if (this.getCodeGenerator().g.getRule(name) != null) {
            return name;
        }
        int ttype = this.getCodeGenerator().g.getTokenType(name);
        if (ttype == 0) {
            return name;
        }
        return this.getTokenTypeAsTargetLabel(this.getCodeGenerator().g, ttype);
    }

    public String getRecognizerFileName(boolean header) {
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String recognizerName = this.gen.g.getRecognizerName();
        return recognizerName + extST.render();
    }

    public String getListenerFileName(boolean header) {
        assert (this.gen.g.name != null);
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.gen.g.name + "Listener";
        return listenerName + extST.render();
    }

    public String getVisitorFileName(boolean header) {
        assert (this.gen.g.name != null);
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.gen.g.name + "Visitor";
        return listenerName + extST.render();
    }

    public String getBaseListenerFileName(boolean header) {
        assert (this.gen.g.name != null);
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.gen.g.name + "BaseListener";
        return listenerName + extST.render();
    }

    public String getBaseVisitorFileName(boolean header) {
        assert (this.gen.g.name != null);
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.gen.g.name + "BaseVisitor";
        return listenerName + extST.render();
    }

    public int getSerializedATNSegmentLimit() {
        return Integer.MAX_VALUE;
    }

    public int getInlineTestSetWordSize() {
        return 64;
    }

    public boolean grammarSymbolCausesIssueInGeneratedCode(GrammarAST idNode) {
        switch (idNode.getParent().getType()) {
            case 10: {
                switch (idNode.getParent().getParent().getType()) {
                    case 42: 
                    case 73: {
                        return false;
                    }
                }
                break;
            }
            case 11: 
            case 73: {
                return false;
            }
            case 75: {
                if (idNode.getChildIndex() != 0) break;
                return false;
            }
        }
        return this.getReservedWords().contains(idNode.getText());
    }

    @Deprecated
    protected boolean visibleGrammarSymbolCausesIssueInGeneratedCode(GrammarAST idNode) {
        return this.getReservedWords().contains(idNode.getText());
    }

    public boolean templatesExist() {
        return this.loadTemplatesHelper(false) != null;
    }

    protected STGroup loadTemplates() {
        STGroup result = this.loadTemplatesHelper(true);
        if (result == null) {
            return null;
        }
        result.registerRenderer(Integer.class, (AttributeRenderer)new NumberRenderer());
        result.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        result.setListener(new STErrorListener(){

            public void compileTimeError(STMessage msg) {
                this.reportError(msg);
            }

            public void runTimeError(STMessage msg) {
                this.reportError(msg);
            }

            public void IOError(STMessage msg) {
                this.reportError(msg);
            }

            public void internalError(STMessage msg) {
                this.reportError(msg);
            }

            private void reportError(STMessage msg) {
                Target.this.getCodeGenerator().tool.errMgr.toolError(ErrorType.STRING_TEMPLATE_WARNING, msg.cause, msg.toString());
            }
        });
        return result;
    }

    private STGroup loadTemplatesHelper(boolean reportErrorIfFail) {
        String language = this.getLanguage();
        String groupFileName = "org/antlr/v4/tool/templates/codegen/" + language + "/" + language + STGroup.GROUP_FILE_EXTENSION;
        try {
            return new STGroupFile(groupFileName);
        }
        catch (IllegalArgumentException iae) {
            if (reportErrorIfFail) {
                this.gen.tool.errMgr.toolError(ErrorType.MISSING_CODE_GEN_TEMPLATES, iae, this.getLanguage());
            }
            return null;
        }
    }

    public boolean wantsBaseListener() {
        return true;
    }

    public boolean wantsBaseVisitor() {
        return true;
    }

    public boolean supportsOverloadedMethods() {
        return true;
    }

    public boolean isATNSerializedAsInts() {
        return true;
    }

    public boolean needsHeader() {
        return false;
    }

    static {
        HashMap<Character, String> map = new HashMap<Character, String>();
        Target.addEscapedChar(map, '\t', 't');
        Target.addEscapedChar(map, '\b', 'b');
        Target.addEscapedChar(map, '\n', 'n');
        Target.addEscapedChar(map, '\r', 'r');
        Target.addEscapedChar(map, '\f', 'f');
        Target.addEscapedChar(map, '\'');
        Target.addEscapedChar(map, '\"');
        Target.addEscapedChar(map, '\\');
        defaultCharValueEscape = map;
    }
}

