/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.weld.spi.BeanDeploymentArchiveServicesProvider;
import org.jboss.as.weld.spi.ModuleServicesProvider;
import org.jboss.as.weld.util.Reflections;
import org.jboss.modules.Module;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.exceptions.IllegalStateException;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class ServiceLoaders {
    private ServiceLoaders() {
    }

    public static <T> Optional<T> loadSingle(Class<T> serviceClass, Class<?> loaderClass) {
        Iterator<T> iterator = ServiceLoader.load(serviceClass, WildFlySecurityManager.getClassLoaderPrivileged(loaderClass)).iterator();
        Object service = null;
        while (iterator.hasNext()) {
            if (service != null) {
                throw new IllegalStateException("Exactly one service provider is required for: " + serviceClass);
            }
            service = iterator.next();
        }
        return Optional.ofNullable(service);
    }

    public static Map<Class<? extends Service>, Service> loadModuleServices(Iterable<ModuleServicesProvider> providers, DeploymentUnit rootDeploymentUnit, DeploymentUnit deploymentUnit, Module module, ResourceRoot resourceRoot) {
        ArrayList services = new ArrayList();
        for (ModuleServicesProvider provider : providers) {
            services.addAll(provider.getServices(rootDeploymentUnit, deploymentUnit, module, resourceRoot));
        }
        HashMap<Class<? extends Service>, Service> servicesMap = new HashMap<Class<? extends Service>, Service>();
        for (Service service : services) {
            for (Class<? extends Service> serviceInterface : ServiceLoaders.identifyServiceInterfaces(service.getClass(), new HashSet<Class<? extends Service>>())) {
                servicesMap.put(serviceInterface, service);
            }
        }
        return servicesMap;
    }

    public static Map<Class<? extends Service>, Service> loadBeanDeploymentArchiveServices(Class<?> clazz, BeanDeploymentArchive archive) {
        ServiceLoader<BeanDeploymentArchiveServicesProvider> serviceLoader = ServiceLoader.load(BeanDeploymentArchiveServicesProvider.class, WildFlySecurityManager.getClassLoaderPrivileged(clazz));
        ArrayList services = new ArrayList();
        for (BeanDeploymentArchiveServicesProvider provider : serviceLoader) {
            services.addAll(provider.getServices(archive));
        }
        HashMap<Class<? extends Service>, Service> servicesMap = new HashMap<Class<? extends Service>, Service>();
        for (Service service : services) {
            for (Class<? extends Service> serviceInterface : ServiceLoaders.identifyServiceInterfaces(service.getClass(), new HashSet<Class<? extends Service>>())) {
                servicesMap.put(serviceInterface, service);
            }
        }
        return servicesMap;
    }

    private static Set<Class<? extends Service>> identifyServiceInterfaces(Class<?> clazz, Set<Class<? extends Service>> serviceInterfaces) {
        if (clazz == null || Object.class.equals(clazz) || BootstrapService.class.equals(clazz)) {
            return serviceInterfaces;
        }
        for (Class<?> interfac3 : clazz.getInterfaces()) {
            if (!Service.class.equals(interfac3) && !BootstrapService.class.equals(interfac3)) continue;
            serviceInterfaces.add((Class)Reflections.cast(clazz));
        }
        for (Class<?> interfac3 : clazz.getInterfaces()) {
            ServiceLoaders.identifyServiceInterfaces(interfac3, serviceInterfaces);
        }
        ServiceLoaders.identifyServiceInterfaces(clazz.getSuperclass(), serviceInterfaces);
        return serviceInterfaces;
    }
}

