/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.api.core.management.ActiveMQComponentControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public abstract class AbstractActiveMQComponentControlHandler<T extends ActiveMQComponentControl>
extends AbstractRuntimeOnlyHandler {
    private static final SimpleAttributeDefinition STARTED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"started", (ModelType)ModelType.BOOLEAN).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    private ParametersValidator readAttributeValidator = new ParametersValidator();

    protected AbstractActiveMQComponentControlHandler() {
        this.readAttributeValidator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        OperationContext.RollbackHandler rh;
        final String operationName = operation.require("operation").asString();
        if ("read-attribute".equals(operationName)) {
            if (ActiveMQActivationService.ignoreOperationIfServerNotActive(context, operation)) {
                return;
            }
            this.readAttributeValidator.validate(operation);
            String name = operation.require("name").asString();
            if (STARTED.getName().equals(name)) {
                T control = this.getActiveMQComponentControl(context, operation, false);
                if (control != null) {
                    context.getResult().set(control.isStarted());
                }
            } else {
                this.handleReadAttribute(name, context, operation);
            }
            return;
        }
        if (ActiveMQActivationService.rollbackOperationIfServerNotActive(context, operation)) {
            return;
        }
        ActiveMQComponentControl control = null;
        boolean appliedToRuntime = false;
        Object handback = null;
        if ("start".equals(operationName)) {
            control = (ActiveMQComponentControl)this.getActiveMQComponentControl(context, operation, true);
            try {
                control.start();
                appliedToRuntime = true;
                context.getResult();
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else if ("stop".equals(operationName)) {
            control = (ActiveMQComponentControl)this.getActiveMQComponentControl(context, operation, true);
            try {
                control.stop();
                appliedToRuntime = true;
                context.getResult();
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else {
            handback = this.handleOperation(operationName, context, operation);
            boolean bl = appliedToRuntime = handback != null;
        }
        if (appliedToRuntime) {
            final ActiveMQComponentControl rhControl = control;
            final Object rhHandback = handback;
            rh = new OperationContext.RollbackHandler(){

                public void handleRollback(OperationContext context, ModelNode operation) {
                    try {
                        if ("start".equals(operationName)) {
                            rhControl.stop();
                        } else if ("stop".equals(operationName)) {
                            rhControl.start();
                        } else {
                            AbstractActiveMQComponentControlHandler.this.handleRevertOperation(operationName, context, operation, rhHandback);
                        }
                    }
                    catch (Exception e) {
                        MessagingLogger.ROOT_LOGGER.revertOperationFailed((Throwable)e, this.getClass().getSimpleName(), operation.require("operation").asString(), PathAddress.pathAddress((ModelNode)operation.require("address")));
                    }
                }
            };
        } else {
            rh = OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER;
        }
        context.completeStep(rh);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        registry.registerReadOnlyAttribute((AttributeDefinition)STARTED, (OperationStepHandler)this);
    }

    public void registerOperations(ManagementResourceRegistration registry, ResourceDescriptionResolver resolver) {
        SimpleOperationDefinition startOp = new SimpleOperationDefinitionBuilder("start", resolver).setRuntimeOnly().build();
        registry.registerOperationHandler((OperationDefinition)startOp, (OperationStepHandler)this);
        SimpleOperationDefinition stopOp = new SimpleOperationDefinitionBuilder("stop", resolver).setRuntimeOnly().build();
        registry.registerOperationHandler((OperationDefinition)stopOp, (OperationStepHandler)this);
    }

    protected abstract T getActiveMQComponentControl(ActiveMQServer var1, PathAddress var2);

    protected abstract String getDescriptionPrefix();

    protected void handleReadAttribute(String attributeName, OperationContext context, ModelNode operation) throws OperationFailedException {
        this.unsupportedAttribute(attributeName);
    }

    protected Object handleOperation(String operationName, OperationContext context, ModelNode operation) throws OperationFailedException {
        this.unsupportedOperation(operationName);
        throw MessagingLogger.ROOT_LOGGER.unsupportedOperation(operationName);
    }

    protected void handleRevertOperation(String operationName, OperationContext context, ModelNode operation, Object handback) {
    }

    protected final void unsupportedAttribute(String attributeName) {
        throw MessagingLogger.ROOT_LOGGER.unsupportedAttribute(attributeName);
    }

    protected final void unsupportedOperation(String operationName) {
        throw MessagingLogger.ROOT_LOGGER.unsupportedOperation(operationName);
    }

    protected final T getActiveMQComponentControl(OperationContext context, ModelNode operation, boolean forWrite) throws OperationFailedException {
        ServiceName artemisServiceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController artemisService = context.getServiceRegistry(forWrite).getService(artemisServiceName);
        ActiveMQServer server = (ActiveMQServer)ActiveMQServer.class.cast(artemisService.getValue());
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        return this.getActiveMQComponentControl(server, address);
    }
}

