/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneBigDecimalFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneNumericIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.engine.backend.types.dsl.ScaledNumberIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneBigDecimalIndexFieldTypeOptionsStep
extends AbstractLuceneNumericIndexFieldTypeOptionsStep<LuceneBigDecimalIndexFieldTypeOptionsStep, BigDecimal>
implements ScaledNumberIndexFieldTypeOptionsStep<LuceneBigDecimalIndexFieldTypeOptionsStep, BigDecimal> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexFieldTypeDefaultsProvider defaultsProvider;
    private Integer decimalScale = null;

    LuceneBigDecimalIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext, IndexFieldTypeDefaultsProvider defaultsProvider) {
        super(buildContext, BigDecimal.class);
        this.defaultsProvider = defaultsProvider;
    }

    public LuceneBigDecimalIndexFieldTypeOptionsStep decimalScale(int decimalScale) {
        this.decimalScale = decimalScale;
        return this;
    }

    @Override
    protected LuceneBigDecimalIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }

    @Override
    protected AbstractLuceneNumericFieldCodec<BigDecimal, ?> createCodec(Indexing indexing, DocValues docValues, Storage storage, BigDecimal indexNullAsValue) {
        int resolvedDecimalScale = this.resolveDecimalScale();
        return new LuceneBigDecimalFieldCodec(indexing, docValues, storage, indexNullAsValue, resolvedDecimalScale);
    }

    private int resolveDecimalScale() {
        if (this.decimalScale != null) {
            return this.decimalScale;
        }
        if (this.defaultsProvider.decimalScale() != null) {
            return this.defaultsProvider.decimalScale();
        }
        throw log.nullDecimalScale(this.buildContext.getEventContext());
    }
}

