/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.FilterLocation;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowFilter;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public final class LocationService
implements Service<LocationService>,
FilterLocation {
    private final Consumer<LocationService> serviceConsumer;
    private final Supplier<HttpHandler> httpHandler;
    private final Supplier<Host> host;
    private final String locationPath;
    private final CopyOnWriteArrayList<UndertowFilter> filters = new CopyOnWriteArrayList();
    private final LocationHandler locationHandler = new LocationHandler();
    private volatile HttpHandler configuredHandler;

    LocationService(Consumer<LocationService> serviceConsumer, Supplier<HttpHandler> httpHandler, Supplier<Host> host, String locationPath) {
        this.serviceConsumer = serviceConsumer;
        this.httpHandler = httpHandler;
        this.host = host;
        this.locationPath = locationPath;
    }

    public void start(StartContext context) {
        UndertowLogger.ROOT_LOGGER.tracef("registering handler %s under path '%s'", this.httpHandler.get(), this.locationPath);
        this.host.get().registerLocation(this);
        this.serviceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.serviceConsumer.accept(null);
        this.host.get().unregisterLocation(this);
    }

    public LocationService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    String getLocationPath() {
        return this.locationPath;
    }

    LocationHandler getLocationHandler() {
        return this.locationHandler;
    }

    private HttpHandler configureHandler() {
        ArrayList<UndertowFilter> filters = new ArrayList<UndertowFilter>(this.filters);
        return LocationService.configureHandlerChain(this.httpHandler.get(), filters);
    }

    protected static HttpHandler configureHandlerChain(HttpHandler rootHandler, List<UndertowFilter> filters) {
        filters.sort((o1, o2) -> Integer.compare(o1.getPriority(), o2.getPriority()));
        Collections.reverse(filters);
        HttpHandler handler = rootHandler;
        for (UndertowFilter filter : filters) {
            handler = filter.wrap(handler);
        }
        return handler;
    }

    @Override
    public void addFilter(UndertowFilter filterRef) {
        this.filters.add(filterRef);
        this.configuredHandler = null;
    }

    @Override
    public void removeFilter(UndertowFilter filterRef) {
        this.filters.remove(filterRef);
        this.configuredHandler = null;
    }

    private class LocationHandler
    implements HttpHandler {
        private LocationHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequest(HttpServerExchange exchange) throws Exception {
            HttpHandler root = LocationService.this.configuredHandler;
            if (root == null) {
                LocationService locationService = LocationService.this;
                synchronized (locationService) {
                    root = LocationService.this.configuredHandler;
                    if (root == null) {
                        root = LocationService.this.configuredHandler = LocationService.this.configureHandler();
                    }
                }
            }
            root.handleRequest(exchange);
        }
    }
}

