/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SybaseSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public SybaseSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSearchedExpression)) {
            List<CaseSearchedExpression.WhenFragment> whenFragments = caseSearchedExpression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, resultRenderer);
        }
    }

    @Override
    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSimpleExpression)) {
            List<CaseSimpleExpression.WhenFragment> whenFragments = caseSimpleExpression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, resultRenderer);
        }
    }

    @Override
    protected boolean renderNamedTableReference(NamedTableReference tableReference, LockMode lockMode) {
        super.renderNamedTableReference(tableReference, lockMode);
        if (LockMode.READ.lessThan(lockMode)) {
            this.appendSql(" holdlock");
        }
        return true;
    }

    @Override
    protected void renderForUpdateClause(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause) {
    }

    @Override
    protected void renderSearchClause(CteStatement cte) {
    }

    @Override
    protected void renderCycleClause(CteStatement cte) {
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        this.assertRowsOnlyFetchClauseType(queryPart);
        if (!queryPart.isRoot() && queryPart.getOffsetClauseExpression() != null) {
            throw new IllegalArgumentException("Can't emulate offset clause in subquery");
        }
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("dummy_.x");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept(this);
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected boolean needsRowsToSkip() {
        return true;
    }

    @Override
    protected boolean needsMaxRows() {
        return true;
    }
}

