/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaType;

public class CaseSimpleExpression
implements Expression,
DomainResultProducer {
    private final MappingModelExpressible type;
    private final Expression fixture;
    private List<WhenFragment> whenFragments = new ArrayList<WhenFragment>();
    private Expression otherwise;

    public CaseSimpleExpression(MappingModelExpressible type, Expression fixture) {
        this.type = type;
        this.fixture = fixture;
    }

    public CaseSimpleExpression(MappingModelExpressible type, Expression fixture, List<WhenFragment> whenFragments, Expression otherwise) {
        this.type = type;
        this.fixture = fixture;
        this.whenFragments = whenFragments;
        this.otherwise = otherwise;
    }

    public Expression getFixture() {
        return this.fixture;
    }

    @Override
    public MappingModelExpressible getExpressionType() {
        return this.type;
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitCaseSimpleExpression(this);
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        JavaType javaType = this.type.getJdbcMappings().get(0).getJavaTypeDescriptor();
        return new BasicResult(creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, javaType, null, creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration()).getValuesArrayPosition(), resultVariable, javaType);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        sqlExpressionResolver.resolveSqlSelection(this, this.type.getJdbcMappings().get(0).getJavaTypeDescriptor(), null, sqlAstCreationState.getCreationContext().getMappingMetamodel().getTypeConfiguration());
    }

    public List<WhenFragment> getWhenFragments() {
        return this.whenFragments;
    }

    public Expression getOtherwise() {
        return this.otherwise;
    }

    public void otherwise(Expression otherwiseExpression) {
        this.otherwise = otherwiseExpression;
    }

    public void when(Expression test, Expression result) {
        this.whenFragments.add(new WhenFragment(test, result));
    }

    public static class WhenFragment
    implements Serializable {
        private final Expression checkValue;
        private final Expression result;

        public WhenFragment(Expression checkValue, Expression result) {
            this.checkValue = checkValue;
            this.result = result;
        }

        public Expression getCheckValue() {
            return this.checkValue;
        }

        public Expression getResult() {
            return this.result;
        }
    }
}

