/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.junit.Assert;
import org.junit.Test;

public class JMXManagementTest
extends JMSClientTestSupport {
    @Test
    public void testListDeliveringMessages() throws Exception {
        SimpleString queue = new SimpleString(this.getQueueName());
        Connection connection1 = this.createConnection();
        Connection connection2 = this.createConnection();
        Session prodSession = connection1.createSession(false, 1);
        Session consSession = connection2.createSession(true, 0);
        Queue jmsQueue = prodSession.createQueue(queue.toString());
        QueueControl queueControl = this.createManagementControl(queue, queue);
        MessageProducer producer = prodSession.createProducer((Destination)jmsQueue);
        int num = 20;
        for (int i = 0; i < 20; ++i) {
            TextMessage message = prodSession.createTextMessage("hello" + i);
            producer.send((Message)message);
        }
        connection2.start();
        MessageConsumer consumer = consSession.createConsumer((Destination)jmsQueue);
        for (int i = 0; i < 20; ++i) {
            TextMessage msgRec = (TextMessage)consumer.receive(5000L);
            JMXManagementTest.assertNotNull((Object)msgRec);
            JMXManagementTest.assertEquals((Object)msgRec.getText(), (Object)("hello" + i));
        }
        JMXManagementTest.assertEquals((long)20L, (long)queueControl.getDeliveringCount());
        Map result = queueControl.listDeliveringMessages();
        JMXManagementTest.assertEquals((long)1L, (long)result.size());
        Map[] msgMaps = (Map[])result.entrySet().iterator().next().getValue();
        JMXManagementTest.assertEquals((long)20L, (long)msgMaps.length);
        consSession.commit();
        result = queueControl.listDeliveringMessages();
        JMXManagementTest.assertEquals((long)0L, (long)result.size());
        consSession.close();
        prodSession.close();
        connection1.close();
        connection2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFirstMessage() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            session.begin();
            AmqpMessage message = new AmqpMessage();
            message.setApplicationProperty("TEST_BINARY", (Object)new Binary("TEST".getBytes()));
            String oneK = new String(new char[1024]).replace("\u0000", "$");
            message.setApplicationProperty("TEST_BIG_BINARY", (Object)new Binary(oneK.getBytes(StandardCharsets.UTF_8)));
            message.setApplicationProperty("TEST_STRING", (Object)oneK);
            message.setText("NOT_VISIBLE");
            sender.send(message);
            session.commit();
            SimpleString queue = new SimpleString(this.getQueueName());
            QueueControl queueControl = this.createManagementControl(queue, queue);
            String firstMessageAsJSON = queueControl.getFirstMessageAsJSON();
            Assert.assertNotNull((Object)firstMessageAsJSON);
            Assert.assertTrue((firstMessageAsJSON.length() < 1500 ? (byte)1 : 0) != 0);
            Assert.assertFalse((boolean)firstMessageAsJSON.contains("NOT_VISIBLE"));
            Map[] result = queueControl.listMessages("");
            JMXManagementTest.assertEquals((long)1L, (long)result.length);
            Map msgMap = result[0];
            Assert.assertTrue((msgMap.get("TEST_STRING").toString().length() < 512 ? (byte)1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFirstMessageWithAMQPTypes() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            UUID uuid = UUID.randomUUID();
            Character character = Character.valueOf('C');
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            session.begin();
            AmqpMessage message = new AmqpMessage();
            message.setApplicationProperty("TEST_UUID", (Object)uuid);
            message.setApplicationProperty("TEST_CHAR", (Object)character);
            message.setApplicationProperty("TEST_DECIMAL_32", (Object)new Decimal32(BigDecimal.ONE));
            message.setApplicationProperty("TEST_DECIMAL_64", (Object)new Decimal64(BigDecimal.ONE));
            message.setApplicationProperty("TEST_DECIMAL_128", (Object)new Decimal128(BigDecimal.ONE));
            sender.send(message);
            session.commit();
            SimpleString queue = new SimpleString(this.getQueueName());
            QueueControl queueControl = this.createManagementControl(queue, queue);
            String firstMessageAsJSON = queueControl.getFirstMessageAsJSON();
            Assert.assertNotNull((Object)firstMessageAsJSON);
            JsonObject firstMessageObject = JsonUtil.readJsonArray((String)firstMessageAsJSON).getJsonObject(0);
            Assert.assertEquals((Object)uuid.toString(), (Object)firstMessageObject.getString("TEST_UUID"));
            Assert.assertEquals((Object)character.toString(), (Object)firstMessageObject.getString("TEST_CHAR"));
            Assert.assertNotNull((Object)firstMessageObject.getJsonNumber("TEST_DECIMAL_32"));
            Assert.assertNotNull((Object)firstMessageObject.getJsonNumber("TEST_DECIMAL_64"));
            Assert.assertNotNull((Object)firstMessageObject.getJsonNumber("TEST_DECIMAL_128"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddressSizeOnDelete() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            session.begin();
            AmqpMessage message = new AmqpMessage();
            message.setApplicationProperty("TEST_STRING", (Object)"TEST");
            message.setTimeToLive(100L);
            message.setText("TEST");
            sender.send(message);
            sender.send(message);
            session.commit();
            PagingStore targetPagingStore = this.server.getPagingManager().getPageStore(SimpleString.toSimpleString((String)this.getQueueName()));
            JMXManagementTest.assertNotNull((Object)targetPagingStore);
            JMXManagementTest.assertTrue((targetPagingStore.getAddressSize() > 0L ? (byte)1 : 0) != 0);
            SimpleString queue = new SimpleString(this.getQueueName());
            QueueControl queueControl = this.createManagementControl(queue, queue);
            Wait.assertEquals((long)2L, () -> ((QueueControl)queueControl).getMessageCount());
            JsonArray array = JsonUtil.readJsonArray((String)queueControl.getFirstMessageAsJSON());
            JsonObject object = (JsonObject)array.get(0);
            queueControl.removeMessage(object.getJsonNumber("messageID").longValue());
            Wait.assertEquals((long)1L, () -> ((QueueControl)queueControl).getMessageCount());
            Map[] messages = queueControl.listMessages("");
            Assert.assertEquals((long)1L, (long)messages.length);
            queueControl.removeMessage(((Long)messages[0].get("messageID")).longValue());
            Assert.assertEquals((long)0L, (long)queueControl.getMessageCount());
            Wait.assertEquals((long)0L, () -> ((PagingStore)targetPagingStore).getAddressSize());
        }
    }

    protected QueueControl createManagementControl(SimpleString address, SimpleString queue) throws Exception {
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, queue, RoutingType.ANYCAST, this.mBeanServer);
        return queueControl;
    }
}

