/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.EnumSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.mod_cluster.CustomLoadMetricResourceDefinition;
import org.wildfly.extension.mod_cluster.DynamicLoadProviderResourceDefinition;
import org.wildfly.extension.mod_cluster.LoadMetricResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterSchema;
import org.wildfly.extension.mod_cluster.ProxyConfigurationResourceDefinition;
import org.wildfly.extension.mod_cluster.SimpleLoadProviderResourceDefinition;
import org.wildfly.extension.mod_cluster.XMLAttribute;
import org.wildfly.extension.mod_cluster.XMLElement;

public final class ModClusterSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(ModClusterSchema.CURRENT.getNamespaceUri(), false);
        ModelNode subsystemModel = context.getModelNode();
        if (subsystemModel.hasDefined(ProxyConfigurationResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property property : subsystemModel.get(ProxyConfigurationResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                String name = property.getName();
                ModelNode proxy = property.getValue();
                ModClusterSubsystemXMLWriter.writeProxy(writer, name, proxy);
            }
        }
        writer.writeEndElement();
    }

    private static void writeProxy(XMLExtendedStreamWriter writer, String name, ModelNode model) throws XMLStreamException {
        ModelNode loadProviderModel;
        writer.writeStartElement(XMLElement.PROXY.getLocalName());
        writer.writeAttribute(XMLAttribute.NAME.getLocalName(), name);
        ModClusterSubsystemXMLWriter.writeAttributes(writer, model, ProxyConfigurationResourceDefinition.Attribute.class);
        if (model.get(SimpleLoadProviderResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
            loadProviderModel = model.get(SimpleLoadProviderResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(XMLElement.SIMPLE_LOAD_PROVIDER.getLocalName());
            ModClusterSubsystemXMLWriter.writeAttributes(writer, loadProviderModel, SimpleLoadProviderResourceDefinition.Attribute.class);
            writer.writeEndElement();
        }
        if (model.get(DynamicLoadProviderResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
            loadProviderModel = model.get(DynamicLoadProviderResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(XMLElement.DYNAMIC_LOAD_PROVIDER.getLocalName());
            ModClusterSubsystemXMLWriter.writeAttributes(writer, loadProviderModel, DynamicLoadProviderResourceDefinition.Attribute.class);
            if (loadProviderModel.hasDefined(LoadMetricResourceDefinition.WILDCARD_PATH.getKey())) {
                for (Property prop : loadProviderModel.get(LoadMetricResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                    ModelNode metricModel = prop.getValue();
                    writer.writeStartElement(XMLElement.LOAD_METRIC.getLocalName());
                    ModClusterSubsystemXMLWriter.writeAttributes(writer, metricModel, LoadMetricResourceDefinition.Attribute.class);
                    ModClusterSubsystemXMLWriter.writeAttributes(writer, metricModel, LoadMetricResourceDefinition.SharedAttribute.class);
                    writer.writeEndElement();
                }
            }
            if (loadProviderModel.hasDefined(CustomLoadMetricResourceDefinition.WILDCARD_PATH.getKey())) {
                for (Property prop : loadProviderModel.get(CustomLoadMetricResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                    ModelNode customMetricModel = prop.getValue();
                    writer.writeStartElement(XMLElement.CUSTOM_LOAD_METRIC.getLocalName());
                    ModClusterSubsystemXMLWriter.writeAttributes(writer, customMetricModel, CustomLoadMetricResourceDefinition.Attribute.class);
                    ModClusterSubsystemXMLWriter.writeAttributes(writer, customMetricModel, LoadMetricResourceDefinition.SharedAttribute.class);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static <A extends Enum<A>> void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Class<A> attributeClass) throws XMLStreamException {
        ModClusterSubsystemXMLWriter.writeAttributes(writer, model, EnumSet.allOf(attributeClass));
    }

    private static void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Iterable<? extends Attribute> attributes) throws XMLStreamException {
        for (Attribute attribute : attributes) {
            ModClusterSubsystemXMLWriter.writeAttribute(writer, model, attribute);
        }
    }

    private static void writeAttribute(XMLExtendedStreamWriter writer, ModelNode model, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getMarshaller().marshallAsAttribute((AttributeDefinition)attribute.getDefinition(), model, true, (XMLStreamWriter)writer);
    }
}

