/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.perf.BenchmarkService;
import org.apache.activemq.artemis.cli.commands.messages.perf.LiveStatistics;
import org.apache.activemq.artemis.cli.commands.messages.perf.MessageListenerBenchmark;
import org.apache.activemq.artemis.cli.commands.messages.perf.MessageListenerBenchmarkBuilder;
import org.apache.activemq.artemis.cli.commands.messages.perf.PerfCommand;
import org.apache.activemq.artemis.cli.commands.messages.perf.ProducerBenchmark;
import org.apache.activemq.artemis.cli.commands.messages.perf.ProducerBenchmarkBuilder;

@Command(name="client", description="It will produce and consume messages to a broker instance")
public class PerfClientCommand
extends PerfCommand {
    @Option(name={"--tx"}, description="Perform Message::acknowledge per each message received (Default: disabled)")
    protected boolean transaction;
    @Option(name={"--shared"}, description="Create shared subscription (Default: 0)")
    protected int sharedSubscription = 0;
    @Option(name={"--durable"}, description="Enabled durable subscription (Default: disabled)")
    protected boolean durableSubscription = false;
    @Option(name={"--consumer-connections"}, description="Number of consumer connections to be used. Default is same as the total number of consumers")
    protected int consumerConnections = 0;
    @Option(name={"--consumers"}, description="Number of consumer to use for each generated destination (Default: 1)")
    protected int consumersPerDestination = 1;
    @Option(name={"--persistent"}, description="It will send messages persistently. Default is non persistent")
    protected boolean persistent = false;
    @Option(name={"--message-size"}, description="Size of each byteMessage (Default is 1024)")
    protected int messageSize = 1024;
    @Option(name={"--rate"}, description="Expected total message rate. (Default is unbounded)")
    protected Long rate = null;
    @Option(name={"--ttl"}, description="TTL for each message")
    protected long ttl = 0L;
    @Option(name={"--group"}, description="Message Group to be used")
    protected String msgGroupID = null;
    @Option(name={"--shared-connections"}, description="It create --threads shared connections among producers (Default: not shared)")
    protected boolean sharedConnections = false;
    @Option(name={"--tx-size"}, description="TX Size")
    protected long txSize;
    @Option(name={"--producers"}, description="Number of producers to use for each generated destination (Default: 1)")
    protected int producersPerDestination = 1;
    @Option(name={"--threads"}, description="Number of worker threads to schedule producer load tasks (Default: 1)")
    protected int threads = 1;
    @Option(name={"--max-pending"}, description="How many not yet completed messages can exists  (Default is 1)")
    protected long maxPending = 1L;
    @Option(name={"--consumer-url"}, description="Setup the url used for MessageListener(s) connections. Default is same as --url")
    protected String consumerUrl = null;
    @Option(name={"--consumer-protocol"}, description="Setup the protocol used for MessageListener(s) connections. Default is same as --protocol")
    protected String consumerProtocol = null;
    @Option(name={"--enable-msg-id"}, description="Enable setting JMS messageID per-message (Default: disabled)")
    protected boolean enableMessageID;
    @Option(name={"--enable-timestamp"}, description="Enable setting JMS timestamp per-message (Default: disabled)")
    protected boolean enableTimestamp;
    private volatile BenchmarkService producerBenchmark;

    @Override
    protected void onExecuteBenchmark(ConnectionFactory producerConnectionFactory, Destination[] jmsDestinations, ActionContext context) throws Exception {
        int totalProducers;
        String listenerProtocol = this.consumerProtocol != null ? this.consumerProtocol : this.getProtocol();
        String listenerUrl = this.consumerUrl != null ? this.consumerUrl : this.brokerURL;
        ConnectionFactory consumerConnectionFactory = this.createConnectionFactory(listenerUrl, this.user, this.password, null, listenerProtocol);
        if (this.consumerConnections == 0) {
            this.consumerConnections = this.sharedSubscription > 0 ? (this.getClientID() == null ? this.sharedSubscription * this.consumersPerDestination * jmsDestinations.length : this.sharedSubscription * jmsDestinations.length) : this.consumersPerDestination * jmsDestinations.length;
        }
        if (this.threads >= (totalProducers = this.producersPerDestination * jmsDestinations.length) && this.threads > totalProducers) {
            context.err.println("Doesn't make sense to set workers > producers: auto-adjusting it to be the same as the producer count");
            this.threads = totalProducers;
        }
        boolean warmingUp = this.warmup != 0;
        StringBuilder skratchBuffer = new StringBuilder();
        try (MessageListenerBenchmark consumerBenchmark = new MessageListenerBenchmarkBuilder().setClientID(this.getClientID()).setDestinations(this.consumerProtocol != null ? this.lookupDestinations(consumerConnectionFactory) : jmsDestinations).setFactory(consumerConnectionFactory).setTransacted(this.transaction).setConsumers(this.consumersPerDestination).setConnections(this.consumerConnections).setTimeProvider(() -> TimeUnit.NANOSECONDS.toMicros(System.nanoTime())).setCanDelayMessageCount(true).setSharedSubscription(this.sharedSubscription).setDurableSubscription(this.durableSubscription).createMessageListenerBenchmark();){
            LiveStatistics statistics;
            DefaultEventLoopGroup eventLoopGroup = new DefaultEventLoopGroup(this.threads){

                protected EventLoop newChild(Executor executor, Object ... args) {
                    return new DefaultEventLoop((EventLoopGroup)this, executor){

                        protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
                            return new LinkedTransferQueue<Runnable>();
                        }
                    };
                }
            };
            try (ProducerBenchmark producerBenchmark = new ProducerBenchmarkBuilder().setPersistent(this.persistent).setDestinations(jmsDestinations).setFactory(producerConnectionFactory).setTtl(this.ttl).setTransactionCapacity(this.txSize).setGroup(this.msgGroupID).setProducers(this.producersPerDestination).setMessageRate(this.rate).setMessageCount(this.messageCount).setMessageSize(this.messageSize).setTimeProvider(() -> TimeUnit.NANOSECONDS.toMicros(System.nanoTime())).setLoopGroup((EventLoopGroup)eventLoopGroup).setMaxPending(this.maxPending).setSharedConnections(this.sharedConnections).setEnableMessageID(this.enableMessageID).setEnableTimestamp(this.enableTimestamp).createProducerBenchmark();){
                this.producerBenchmark = producerBenchmark;
                consumerBenchmark.start();
                producerBenchmark.start();
                long now = System.currentTimeMillis();
                long endWarmup = this.warmup > 0 ? now + TimeUnit.SECONDS.toMillis(this.warmup) : 0L;
                long end = this.duration > 0 ? now + TimeUnit.SECONDS.toMillis(this.duration) : 0L;
                statistics = new LiveStatistics(this.reportFileName, this.hdrFileName, producerBenchmark.getGenerators(), consumerBenchmark.getListeners());
                LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(1L));
                warmingUp = this.collectAndReportStatisticsWhileRunning(warmingUp, statistics, skratchBuffer, endWarmup, end, producerBenchmark);
                boolean producerFatalError = producerBenchmark.anyError();
                producerBenchmark.asyncClose();
                if (!producerFatalError) {
                    consumerBenchmark.setMessageCount(producerBenchmark.expectedTotalMessageCountToReceive(this.sharedSubscription, this.consumersPerDestination));
                    warmingUp = this.collectAndReportStatisticsWhileRunning(warmingUp, statistics, skratchBuffer, endWarmup, 0L, consumerBenchmark);
                }
            }
            statistics.sampleMetrics(warmingUp);
            skratchBuffer.setLength(0);
            statistics.outSummary(skratchBuffer);
            if (!this.isSilentInput()) {
                context.out.println(skratchBuffer);
            }
            eventLoopGroup.shutdownGracefully();
            statistics.close();
        }
    }

    @Override
    protected void onInterruptBenchmark() {
        BenchmarkService benchmark = this.producerBenchmark;
        if (benchmark != null) {
            benchmark.close();
        }
    }
}

