/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.infinispan.Cache;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.util.concurrent.CompletableFutures;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.controller.ServiceValueCaptor;
import org.jboss.as.clustering.controller.ServiceValueRegistry;
import org.jboss.as.clustering.infinispan.logging.InfinispanLogger;
import org.jboss.as.clustering.infinispan.manager.DefaultCacheContainer;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheRuntimeResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.infinispan.service.InfinispanRequirement;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

@Listener
public class CacheContainerServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
UnaryOperator<EmbeddedCacheManager>,
Supplier<EmbeddedCacheManager>,
Consumer<EmbeddedCacheManager> {
    private final ServiceValueRegistry<Cache<?, ?>> registry;
    private final Map<String, Registration> registrations = new ConcurrentHashMap<String, Registration>();
    private final PathAddress address;
    private final String name;
    private final SupplierDependency<GlobalConfiguration> configuration;
    private final SupplierDependency<ModuleLoader> loader;
    private volatile ExecutorService executor;
    private volatile Registrar<String> registrar;
    private volatile ServiceName[] names;

    public CacheContainerServiceConfigurator(PathAddress address, ServiceValueRegistry<Cache<?, ?>> registry) {
        super((Capability)CacheContainerResourceDefinition.Capability.CONTAINER, address);
        this.address = address;
        this.name = address.getLastElement().getValue();
        this.configuration = new ServiceSupplierDependency(CacheContainerResourceDefinition.Capability.CONFIGURATION.getServiceName(address));
        this.loader = new ServiceSupplierDependency(Services.JBOSS_SERVICE_MODULE_LOADER);
        this.registry = registry;
    }

    @Override
    public EmbeddedCacheManager apply(EmbeddedCacheManager manager) {
        return new DefaultCacheContainer(manager, (ModuleLoader)this.loader.get());
    }

    @Override
    public EmbeddedCacheManager get() {
        GlobalConfiguration config = (GlobalConfiguration)this.configuration.get();
        String defaultCacheName = config.defaultCacheName().orElse(null);
        ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder(config.classLoader(), new GlobalConfigurationBuilder().read(config));
        if (defaultCacheName != null) {
            holder.newConfigurationBuilder(defaultCacheName);
        }
        DefaultCacheManager manager = new DefaultCacheManager(holder, false);
        if (defaultCacheName != null) {
            manager.undefineConfiguration(defaultCacheName);
        }
        manager.start();
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory(this.getClass()));
        manager.addListener((Object)this);
        InfinispanLogger.ROOT_LOGGER.debugf("%s cache container started", this.name);
        return manager;
    }

    @Override
    public void accept(EmbeddedCacheManager manager) {
        manager.removeListener((Object)this);
        manager.stop();
        InfinispanLogger.ROOT_LOGGER.debugf("%s cache container stopped", this.name);
        this.executor.shutdown();
    }

    public CacheContainerServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        List aliases = CacheContainerResourceDefinition.ListAttribute.ALIASES.resolveModelAttribute((ExpressionResolver)context, model).asListOrEmpty();
        this.names = new ServiceName[aliases.size() + 1];
        this.names[0] = this.getServiceName();
        for (int i = 0; i < aliases.size(); ++i) {
            this.names[i + 1] = InfinispanRequirement.CONTAINER.getServiceName(context.getCapabilityServiceSupport(), ((ModelNode)aliases.get(i)).asString());
        }
        this.registrar = (CacheContainerResource)context.readResource(PathAddress.EMPTY_ADDRESS);
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = new AsyncServiceConfigurator(this.getServiceName()).build(target);
        Consumer container = new CompositeDependency(new Dependency[]{this.configuration, this.loader}).register(builder).provides(this.names);
        FunctionalService service = new FunctionalService(container, (Function)this, (Supplier)this, (Consumer)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.PASSIVE);
    }

    private ServiceName createCacheServiceName(String cacheName) {
        return CacheResourceDefinition.Capability.CACHE.getServiceName(this.address.append(new PathElement[]{CacheRuntimeResourceDefinition.pathElement(cacheName)}));
    }

    @CacheStarted
    public CompletionStage<Void> cacheStarted(final CacheStartedEvent event) {
        final String cacheName = event.getCacheName();
        InfinispanLogger.ROOT_LOGGER.cacheStarted(cacheName, this.name);
        this.registrations.put(cacheName, this.registrar.register((Object)cacheName));
        final ServiceValueCaptor captor = this.registry.add(this.createCacheServiceName(cacheName));
        try {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    captor.accept((Object)event.getCacheManager().getCache(cacheName));
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return CompletableFutures.completedNull();
    }

    @CacheStopped
    public CompletionStage<Void> cacheStopped(CacheStoppedEvent event) {
        String cacheName = event.getCacheName();
        ServiceValueCaptor captor = this.registry.remove(this.createCacheServiceName(cacheName));
        if (captor != null) {
            captor.accept(null);
        }
        try (Registration registration = this.registrations.remove(cacheName);){
            InfinispanLogger.ROOT_LOGGER.cacheStopped(cacheName, this.name);
        }
        return CompletableFutures.completedNull();
    }
}

