/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.Resolvable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SortableValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.Type;

public class DependantValue
extends SimpleValue
implements Resolvable,
SortableValue {
    private KeyValue wrappedValue;
    private boolean nullable;
    private boolean updateable;
    private boolean sorted;

    public DependantValue(MetadataBuildingContext buildingContext, Table table, KeyValue prototype) {
        super(buildingContext, table);
        this.wrappedValue = prototype;
    }

    private DependantValue(DependantValue original) {
        super(original);
        this.wrappedValue = (KeyValue)original.wrappedValue.copy();
        this.nullable = original.nullable;
        this.updateable = original.updateable;
        this.sorted = original.sorted;
    }

    @Override
    public DependantValue copy() {
        return new DependantValue(this);
    }

    public KeyValue getWrappedValue() {
        return this.wrappedValue;
    }

    @Override
    public Type getType() throws MappingException {
        return this.wrappedValue.getType();
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) {
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    @Override
    public boolean isSame(SimpleValue other) {
        return other instanceof DependantValue && this.isSame((DependantValue)other);
    }

    public boolean isSame(DependantValue other) {
        return super.isSame(other) && DependantValue.isSame(this.wrappedValue, other.wrappedValue);
    }

    @Override
    public boolean resolve(MetadataBuildingContext buildingContext) {
        this.resolve();
        return true;
    }

    @Override
    public BasicValue.Resolution<?> resolve() {
        if (this.wrappedValue instanceof BasicValue) {
            return ((BasicValue)this.wrappedValue).resolve();
        }
        throw new UnsupportedOperationException("Trying to resolve the wrapped value but it is non a BasicValue");
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    @Override
    public int[] sortProperties() {
        if (!this.sorted) {
            int[] originalOrder;
            this.sorted = true;
            if (this.wrappedValue instanceof SortableValue && (originalOrder = ((SortableValue)((Object)this.wrappedValue)).sortProperties()) != null) {
                this.sortColumns(originalOrder);
            }
        }
        return null;
    }
}

