/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.AnyDiscriminatorSqmPath;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class AnyDiscriminatorSqmPathSource<D>
extends AbstractSqmPathSource<D>
implements ReturnableType<D> {
    public AnyDiscriminatorSqmPathSource(String localPathName, SimpleDomainType<D> domainType, Bindable.BindableType jpaBindableType) {
        super(localPathName, domainType, jpaBindableType);
    }

    @Override
    public SqmPath<D> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        NavigablePath navigablePath = intermediatePathSource == null ? lhs.getNavigablePath() : lhs.getNavigablePath().append(intermediatePathSource.getPathName());
        return new AnyDiscriminatorSqmPath(navigablePath, this, lhs, lhs.nodeBuilder());
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        throw new IllegalStateException("Entity discriminator cannot be de-referenced");
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.BASIC;
    }

    public Class<D> getJavaType() {
        return this.getExpressibleJavaType().getJavaTypeClass();
    }

    @Override
    public BasicType<D> getSqmPathType() {
        return (BasicType)super.getSqmPathType();
    }

    @Override
    public JavaType<D> getExpressibleJavaType() {
        return this.getSqmPathType().getExpressibleJavaType();
    }
}

