/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.ListPersistentAttribute;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSpecificPluralPartPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;

public class SqmIndexAggregateFunction<T>
extends AbstractSqmSpecificPluralPartPath<T> {
    private final SqmPathSource<T> indexPathSource;
    private final String functionName;

    public SqmIndexAggregateFunction(SqmPath<?> pluralDomainPath, String functionName) {
        super(pluralDomainPath.getNavigablePath().getParent().append(pluralDomainPath.getNavigablePath().getLocalName(), "{" + functionName + "-index}"), pluralDomainPath, (PluralPersistentAttribute)pluralDomainPath.getReferencedPathSource());
        this.functionName = functionName;
        if (this.getPluralAttribute() instanceof ListPersistentAttribute) {
            this.indexPathSource = this.getPluralAttribute().getIndexPathSource();
        } else if (this.getPluralAttribute() instanceof MapPersistentAttribute) {
            this.indexPathSource = ((MapPersistentAttribute)this.getPluralAttribute()).getKeyPathSource();
        } else {
            throw new UnsupportedOperationException("Plural attribute [" + this.getPluralAttribute() + "] is not indexed");
        }
    }

    @Override
    public SqmIndexAggregateFunction<T> copy(SqmCopyContext context) {
        SqmIndexAggregateFunction existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmIndexAggregateFunction<T> path = context.registerCopy(this, new SqmIndexAggregateFunction<T>((SqmPath<?>)this.getLhs().copy(context), this.functionName));
        this.copyTo(path, context);
        return path;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        JpaPath sqmPath = this.get(name);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register((SqmPath<?>)sqmPath);
        return sqmPath;
    }

    @Override
    public SqmPathSource<T> getReferencedPathSource() {
        return this.indexPathSource;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitIndexAggregateFunction(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append(this.functionName).append("(");
        this.getLhs().appendHqlString(sb);
        sb.append(')');
    }
}

